/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.document.utils;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.edt.compiler.core.ast.ClassDataDeclaration;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.SimpleName;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.rui.document.utils.AddImportOperation;
import org.eclipse.edt.ide.rui.document.utils.TypeNameResolver;

public class DocumentUtil {
    public static void addQualifiedImports(IFile currentFile, IEGLDocument currentDocument, List imports) {
        int i = 0;
        while (i < imports.size()) {
            String fullTypeName = (String)imports.get(i);
            AddImportOperation addImportOp = new AddImportOperation(currentDocument, currentFile);
            addImportOp.addFullyQualifiedImport(fullTypeName);
            ++i;
        }
    }

    public static String handleTypeNameVaraibles(IFile currentFile, IEGLDocument currentDocument, String template, List imports) {
        int startIndex = 0;
        while ((startIndex = template.indexOf("${typeName:")) != -1) {
            String typeNameVaraible = template.substring(startIndex, template.indexOf("}", startIndex) + 1);
            String fullTypeName = typeNameVaraible.substring("${typeName:".length(), typeNameVaraible.length() - 1).trim();
            int index = fullTypeName.lastIndexOf(".");
            String packageName = fullTypeName.substring(0, index);
            String typeName = fullTypeName.substring(index + 1);
            TypeNameResolver typeNameResolver = new TypeNameResolver(currentFile);
            typeNameResolver.resolveTypeName(packageName, typeName);
            template = DocumentUtil.replaceAll(template, typeNameVaraible, typeNameResolver.getTypeName());
            if (!typeNameResolver.requiresQualifiedImport()) continue;
            imports.add(fullTypeName);
        }
        return template;
    }

    public static Node getWidgetNode(IEGLDocument currentDocument, int iStatementOffset, int iStatementLength) {
        List names;
        Node widgetNode = currentDocument.getNewModelNodeAtOffset(iStatementOffset, iStatementLength);
        if (widgetNode instanceof ClassDataDeclaration && (names = ((ClassDataDeclaration)widgetNode).getNames()).size() == 1 && names.get(0) instanceof SimpleName) {
            return (SimpleName)names.get(0);
        }
        return widgetNode;
    }

    private static String replaceAll(String template, String oldString, String newString) {
        int startIndex = 0;
        while ((startIndex = template.indexOf(oldString)) != -1) {
            String start = template.substring(0, startIndex);
            String end = template.substring(startIndex + oldString.length());
            template = String.valueOf(start) + newString + end;
        }
        return template;
    }
}

