/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.javart.util.gzip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.edt.javart.resources.Trace;

public class CompressionServletOutputStream
extends ServletOutputStream {
    protected int compressionThreshold = 0;
    protected byte[] buffer = null;
    protected int bufferCount = 0;
    protected GZIPOutputStream gzipstream = null;
    protected boolean closed = false;
    protected int length = -1;
    protected HttpServletResponse response = null;
    protected ServletOutputStream output = null;
    private ByteArrayOutputStream byteStream = null;
    protected int beforeCompress;
    protected int afterCompress;
    protected Trace tracer;
    protected static final String CLOSED_STREAM_MSG = "This output stream has already been closed";
    protected static final String CANNOT_WRITE_MSG = "Cannot write to a closed output stream";

    public CompressionServletOutputStream(HttpServletResponse response, Trace tracer) throws IOException {
        this.response = response;
        this.output = response.getOutputStream();
        this.tracer = tracer;
    }

    protected void setBuffer(int threshold) {
        this.compressionThreshold = threshold;
        this.buffer = new byte[this.compressionThreshold];
    }

    public void close() throws IOException {
        if (this.closed) {
            throw new IOException(CLOSED_STREAM_MSG);
        }
        if (this.gzipstream != null) {
            this.flushToGZip();
            this.gzipstream.close();
            this.gzipstream = null;
            if (this.tracer.traceIsOn()) {
                this.afterCompress += this.byteStream.size();
                this.byteStream.writeTo((OutputStream)this.output);
                this.byteStream.close();
                this.tracer.put("Befor Compress: " + this.beforeCompress + "   After Compress: " + this.afterCompress);
            }
        } else if (this.bufferCount > 0) {
            this.output.write(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
        this.output.close();
        this.closed = true;
    }

    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("");
        }
        if (this.gzipstream != null) {
            this.gzipstream.flush();
        }
    }

    public void flushToGZip() throws IOException {
        if (this.bufferCount > 0) {
            this.writeToGZip(this.buffer, 0, this.bufferCount);
            this.bufferCount = 0;
        }
    }

    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException(CLOSED_STREAM_MSG);
        }
        if (this.bufferCount >= this.buffer.length) {
            this.flushToGZip();
        }
        this.buffer[this.bufferCount++] = (byte)b;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException(CANNOT_WRITE_MSG);
        }
        if (len == 0) {
            return;
        }
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.flushToGZip();
        if (len <= this.buffer.length - this.bufferCount) {
            System.arraycopy(b, off, this.buffer, this.bufferCount, len);
            this.bufferCount += len;
            return;
        }
        this.writeToGZip(b, off, len);
    }

    public void writeToGZip(byte[] b, int off, int len) throws IOException {
        if (this.gzipstream == null) {
            this.response.addHeader("Content-Encoding", "gzip");
            if (this.tracer.traceIsOn()) {
                this.byteStream = new ByteArrayOutputStream();
                this.gzipstream = new GZIPOutputStream(this.byteStream);
            } else {
                this.gzipstream = new GZIPOutputStream((OutputStream)this.output);
            }
        }
        this.gzipstream.write(b, off, len);
        if (this.tracer.traceIsOn()) {
            this.beforeCompress += len;
        }
    }
}

