/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.eunit.ui.testresult;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.edt.ide.eunit.ui.testresult.ResultSummaryBlock;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.forms.IManagedForm;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RSTreeContentProvider
implements ITreeContentProvider {
    private HashMap<String, ResultSummaryBlock.TestResultPkgNode> map;

    public void dispose() {
    }

    public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
    }

    public Object getParent(Object arg0) {
        return null;
    }

    public boolean hasChildren(Object arg0) {
        Object[] children = this.getChildren(arg0);
        if (children == null) {
            return false;
        }
        return children.length > 0;
    }

    public Object[] getElements(Object arg0) {
        return this.getChildren(arg0);
    }

    public Object[] getChildren(Object inputElem) {
        if (inputElem instanceof IManagedForm) {
            IManagedForm form = (IManagedForm)inputElem;
            return new Object[]{form.getInput()};
        }
        if (inputElem instanceof ResultSummaryBlock.TestResultRootNode) {
            this.populateTree((ResultSummaryBlock.TestResultRootNode)inputElem);
            return this.map.values().toArray();
        }
        if (inputElem instanceof ResultSummaryBlock.TestResultPkgNode) {
            ResultSummaryBlock.TestResultPkgNode pkgNode = (ResultSummaryBlock.TestResultPkgNode)inputElem;
            ArrayList<ResultSummaryBlock.Record_ResultSummary> rsList = pkgNode.listRS;
            return rsList.toArray();
        }
        return null;
    }

    private void populateTree(ResultSummaryBlock.TestResultRootNode rootNode) {
        if (this.map == null) {
            this.map = new HashMap();
            rootNode.expectedTotalTestVariationCnt = Integer.parseInt(rootNode.elemRoot.getAttribute("expCnt"));
            rootNode.startTS = rootNode.elemRoot.getAttribute("startTS");
            rootNode.endRunTS = rootNode.elemRoot.getAttribute("endRunTS");
            rootNode.finalTS = rootNode.elemRoot.getAttribute("finalTS");
            NodeList nl = rootNode.elemRoot.getElementsByTagName("trSum");
            if (nl != null && nl.getLength() > 0) {
                int i = 0;
                while (i < nl.getLength()) {
                    Element el = (Element)nl.item(i);
                    ResultSummaryBlock.Record_ResultSummary rs = this.getRecordResultSummary(el);
                    ResultSummaryBlock.TestResultPkgNode pkgNode = this.map.get(rs.pkgName);
                    if (pkgNode == null) {
                        pkgNode = new ResultSummaryBlock.TestResultPkgNode();
                        pkgNode.pkgName = rs.pkgName;
                    }
                    if (pkgNode.listRS == null) {
                        pkgNode.listRS = new ArrayList();
                    }
                    pkgNode.listRS.add(rs);
                    if (!rs.isSuccessful) {
                        pkgNode.isSuccessful = false;
                        rootNode.isSuccessful = false;
                    }
                    this.map.put(rs.pkgName, pkgNode);
                    pkgNode.statisticCnts = pkgNode.statisticCnts.plus(rs.statisticCnts);
                    rootNode.statisticCnts = rootNode.statisticCnts.plus(rs.statisticCnts);
                    ++i;
                }
            }
        }
    }

    private ResultSummaryBlock.Record_ResultSummary getRecordResultSummary(Element el) {
        String name = el.getAttribute("name");
        String pkgName = el.getAttribute("pkgName");
        String sResult = el.getAttribute("code");
        int resultCode = Integer.parseInt(sResult);
        int testCnt = Integer.parseInt(el.getAttribute("tCnt"));
        int expectedCnt = Integer.parseInt(el.getAttribute("expCnt"));
        int passedCnt = Integer.parseInt(el.getAttribute("passCnt"));
        int failedCnt = Integer.parseInt(el.getAttribute("failCnt"));
        int exCnt = Integer.parseInt(el.getAttribute("errCnt"));
        int badCnt = Integer.parseInt(el.getAttribute("badCnt"));
        int notRunCnt = Integer.parseInt(el.getAttribute("skipCnt"));
        ResultSummaryBlock.ResultStatisticCnts statisticCnt = new ResultSummaryBlock.ResultStatisticCnts(testCnt, expectedCnt, passedCnt, failedCnt, exCnt, badCnt, notRunCnt);
        ResultSummaryBlock.Record_ResultSummary rs = new ResultSummaryBlock.Record_ResultSummary(pkgName, name, resultCode, statisticCnt);
        return rs;
    }
}

