/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.editor;

import org.eclipse.edt.ide.rui.visualeditor.internal.actions.EvActionWidgetDelete;
import org.eclipse.edt.ide.rui.visualeditor.internal.actions.EvActionWidgetProperties;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOutlineProvider;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvEditorOutlinePage;
import org.eclipse.edt.ide.rui.visualeditor.internal.outline.WidgetDragListener;
import org.eclipse.edt.ide.rui.visualeditor.internal.outline.WidgetDropAdapter;
import org.eclipse.edt.ide.rui.visualeditor.internal.outline.WidgetTransfer;
import org.eclipse.edt.ide.rui.visualeditor.internal.widget.WidgetPart;
import org.eclipse.gef.dnd.TemplateTransfer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class EvDesignOutlinePage
extends ContentOutlinePage
implements KeyListener {
    protected EvDesignPage _designPage = null;
    protected WidgetPart _model = null;
    protected boolean _bProcessingSelectionChange = false;
    protected EvEditorOutlinePage _editorOutlinePage = null;

    public EvDesignOutlinePage(EvDesignPage editor) {
        this._designPage = editor;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        TreeViewer treeViewer = this.getTreeViewer();
        int ops = 2;
        WidgetTransfer transfer = new WidgetTransfer(this._designPage.getWidgetManager());
        Transfer[] transfers = new Transfer[]{transfer};
        treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new WidgetDragListener((StructuredViewer)treeViewer, transfer));
        transfers = new Transfer[]{transfer, TemplateTransfer.getInstance()};
        WidgetDropAdapter dropAdapter = new WidgetDropAdapter(treeViewer, this._designPage, transfer, this._designPage._overlay);
        treeViewer.addDropSupport(ops, transfers, (DropTargetListener)dropAdapter);
        treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        treeViewer.getTree().addKeyListener((KeyListener)this);
        EvDesignOutlineProvider provider = new EvDesignOutlineProvider();
        treeViewer.setContentProvider((IContentProvider)provider);
        treeViewer.setLabelProvider((IBaseLabelProvider)provider);
        treeViewer.setAutoExpandLevel(4);
        this._model = this._designPage.getWidgetManager().getWidgetRoot();
        if (this._model != null) {
            treeViewer.setInput((Object)this._model);
            StructuredSelection selection = new StructuredSelection((Object)this._model);
            this.setSelection((ISelection)selection);
        }
        this.createContextMenu();
    }

    protected void createContextMenu() {
        MenuManager manager = new MenuManager("", "org.eclipse.edt.ide.rui.visualeditor.outline.manu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                EvDesignOutlinePage.this.contextMenuAboutToShow(manager);
            }
        });
        this._editorOutlinePage.getSite().registerContextMenu("org.eclipse.edt.ide.rui.visualeditor.outline", manager, (ISelectionProvider)this.getTreeViewer());
        Control c = this.getTreeViewer().getControl();
        Menu menu = manager.createContextMenu(c);
        c.setMenu(menu);
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        boolean actionEnabled = selection != null && selection.size() == 1;
        EvActionWidgetDelete deleteAction = this._designPage._overlay._actionWidgetDelete;
        menu.add((IAction)deleteAction);
        menu.add((IContributionItem)new Separator());
        EvActionWidgetProperties propertyAction = this._designPage._overlay._actionWidgetProperties;
        menu.add((IAction)propertyAction);
        propertyAction.setEnabled(actionEnabled);
    }

    public ISelection getSelection() {
        if (this.getTreeViewer().getTree() != null && !this.getTreeViewer().getTree().isDisposed()) {
            return this.getTreeViewer().getSelection();
        }
        return null;
    }

    public void partSelected(WidgetPart nodeSelected, String strSource) {
        StructuredSelection selection = new StructuredSelection((Object)nodeSelected);
        this.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.setSelection((ISelection)selection);
        this.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectView() {
        TreeViewer treeViewer = this.getTreeViewer();
        TreeItem[] items0 = treeViewer.getTree().getItems();
        TreeItem[] items1 = items0[0].getItems();
        TreeItem[] itemsSelect = new TreeItem[]{items1.length > 0 ? items1[0] : items0[0]};
        treeViewer.getTree().setSelection(itemsSelect);
    }

    public void setEnabled(boolean bEnable) {
        Control control;
        if (this.getTreeViewer() != null && !(control = this.getTreeViewer().getControl()).isDisposed()) {
            control.setEnabled(bEnable);
        }
    }

    public void setInput(Object input) {
        if (input instanceof WidgetPart) {
            this._model = (WidgetPart)input;
        }
        this.update();
    }

    public void setSelection(ISelection selection) {
        if (this.getTreeViewer() == null) {
            return;
        }
        if (this.getTreeViewer().getTree() != null && !this.getTreeViewer().getTree().isDisposed()) {
            this.getTreeViewer().setSelection(selection);
        }
    }

    public void update() {
        Control control;
        if (this.getTreeViewer() != null && !(control = this.getTreeViewer().getControl()).isDisposed()) {
            control.setRedraw(false);
            this._model = this._designPage.getWidgetManager().getWidgetRoot();
            this.getTreeViewer().setInput((Object)this._model);
            WidgetPart part = this._designPage.getEditor().getWidgetSelected();
            if (part != null) {
                StructuredSelection selection = new StructuredSelection((Object)part);
                this.setSelection((ISelection)selection);
            }
            control.setRedraw(true);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.keyCode == 127) {
            this._designPage._overlay._actionWidgetDelete.run();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

