/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlay;
import org.eclipse.edt.ide.rui.visualeditor.internal.editor.EvDesignOverlayDropLocation;
import org.eclipse.edt.ide.rui.visualeditor.internal.nl.Messages;
import org.eclipse.edt.ide.rui.visualeditor.internal.views.dataview.model.PageDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.GenerationProgress;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertDataNode;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertWidgetWizardPage;
import org.eclipse.edt.ide.rui.visualeditor.internal.wizards.insertwidget.InsertWidgetWizardUtil;
import org.eclipse.edt.ide.rui.visualeditor.plugin.Activator;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class InsertWidgetWizard
extends Wizard {
    private EvDesignOverlay evDesignOverlay;
    private EvDesignOverlayDropLocation dropLocation;
    private InsertWidgetWizardPage insertWidgetWizardPage;

    public InsertWidgetWizard(PageDataNode selectedEGLNode, EvDesignOverlay evDesignOverlay, EvDesignOverlayDropLocation dropLocation) {
        this.setWindowTitle(Messages.NL_IWW_Title);
        this.setDefaultPageImageDescriptor(Activator.getImageDescriptor("obj16/insertWidgetWizard.gif"));
        this.evDesignOverlay = evDesignOverlay;
        this.dropLocation = dropLocation;
        IProject project = evDesignOverlay.getDesignPage().getEditor().getProject();
        IEditorInput editorInput = evDesignOverlay.getDesignPage().getEditor().getEditorInput();
        this.insertWidgetWizardPage = new InsertWidgetWizardPage(selectedEGLNode, project, editorInput);
    }

    public void addPages() {
        this.addPage((IWizardPage)this.insertWidgetWizardPage);
    }

    public boolean performFinish() {
        InsertDataNode rootInsertDataNode;
        TreeItem firstTreeItem;
        CheckboxTreeViewer configureWidgetsTableViewer = this.insertWidgetWizardPage.getConfigureWidgetsTableViewer();
        Object[] checkedElements = configureWidgetsTableViewer.getCheckedElements();
        int i = 0;
        while (i < checkedElements.length) {
            Object checkedElement = checkedElements[i];
            if (checkedElement instanceof InsertDataNode) {
                InsertDataNode insertDataNode = (InsertDataNode)checkedElement;
                Activator.getDefault().getPreferenceStore().putValue(String.valueOf(insertDataNode.getBindingName()) + insertDataNode.getPurpose(), insertDataNode.getWidgetType().getName());
                if (!InsertWidgetWizardUtil.isAnEmbedRecord(insertDataNode) && !InsertWidgetWizardUtil.isAPrimitiveArrayInRecord(insertDataNode)) {
                    insertDataNode.setGen(true);
                    if (insertDataNode.getWidgetName() == null) {
                        insertDataNode.setWidgetName(insertDataNode.getDefaultWidgetName());
                    }
                }
            }
            ++i;
        }
        TreeItem[] treeItems = configureWidgetsTableViewer.getTree().getItems();
        if (treeItems != null && treeItems.length > 0 && (firstTreeItem = treeItems[0]).getData() instanceof InsertDataNode && (rootInsertDataNode = (InsertDataNode)firstTreeItem.getData()).isGen()) {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            try {
                progressService.runInUI((IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IRunnableWithProgress)new GenerationProgress(rootInsertDataNode, this.evDesignOverlay, this.dropLocation), (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            }
            catch (InvocationTargetException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "InvocationTargetException while insert widget.", (Throwable)e));
            }
            catch (InterruptedException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.edt.ide.rui.visualeditor", "InterruptedException while insert widget.", (Throwable)e));
            }
        }
        return true;
    }
}

