/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.dataaccess.conversion.sqldb;

import java.util.Hashtable;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.edt.gen.generator.eglsource.EglSourceContext;
import org.eclipse.edt.ide.ui.internal.dataaccess.conversion.sqldb.DataToolsObjectsToEGLUtils;
import org.eclipse.edt.ide.ui.internal.dataaccess.conversion.sqldb.EGLCodeTemplate;

public class DataToolsSqlTableTemplate
extends org.eclipse.edt.ide.ui.internal.record.conversion.sqldb.DataToolsSqlTableTemplate {
    private final String genEntityRecordColumnMethodName = "genEntityRecordColumn";
    private final String genSearchRecordColumnMethodName = "genSearchRecordColumn";

    @Override
    public void genTable(Table table, EglSourceContext ctx) {
        Hashtable variables = ctx.getVariables();
        DataToolsObjectsToEGLUtils.cleanTableVariable(variables);
        variables.put("entityName", this.getEntityRecordName(table));
        variables.put("entityRecordName", this.getEntityRecordName(table));
        boolean isTableQualified = (Boolean)ctx.get((Object)"tableNameQualified");
        if (isTableQualified) {
            variables.put("schemaName", table.getSchema().getName());
            variables.put("schemaPrefix", String.valueOf(table.getSchema().getName()) + ".");
        } else {
            variables.put("schemaName", "");
            variables.put("schemaPrefix", "");
        }
        this.genRecordEGLFile(table, ctx);
        this.updateCRUDMethod(ctx);
    }

    public void updateCRUDMethod(EglSourceContext ctx) {
        Hashtable variables = ctx.getVariables();
        String addMethod = DataToolsObjectsToEGLUtils.getReplacedString(EGLCodeTemplate.mdd_addMethods, variables);
        ctx.appendVariableValue("serviceLibraryMethods", addMethod, "\n");
        if (ctx.getVariables().get("searchMethodParam") != null) {
            String getMethod = DataToolsObjectsToEGLUtils.getReplacedString(EGLCodeTemplate.mdd_getmethod, variables);
            ctx.appendVariableValue("serviceLibraryMethods", getMethod, "\n");
            String udpateMethod = DataToolsObjectsToEGLUtils.getReplacedString(EGLCodeTemplate.mdd_updatemethod, variables);
            ctx.appendVariableValue("serviceLibraryMethods", udpateMethod, "\n");
            String deleteMethod = DataToolsObjectsToEGLUtils.getReplacedString(EGLCodeTemplate.mdd_deleteMethod, variables);
            ctx.appendVariableValue("serviceLibraryMethods", deleteMethod, "\n");
            String existMethod = DataToolsObjectsToEGLUtils.getReplacedString(EGLCodeTemplate.mdd_existMethod, variables);
            ctx.appendVariableValue("serviceLibraryMethods", existMethod, "\n");
        }
        String isValidMethod = DataToolsObjectsToEGLUtils.getReplacedString(EGLCodeTemplate.mdd_isValidmethod, variables);
        ctx.appendVariableValue("serviceLibraryMethods", isValidMethod, "\n");
    }

    public void genRecordEGLFile(Table table, EglSourceContext ctx) {
        Object column;
        Object[] columns;
        Hashtable variable = ctx.getVariables();
        String fileName = this.getEntityRecordName(table);
        String packageName = (String)variable.get("javaJsPackageName");
        String filePath = DataToolsObjectsToEGLUtils.getEGLFilePath(packageName, fileName);
        StringBuilder recordsDef = new StringBuilder();
        recordsDef.append(DataToolsObjectsToEGLUtils.getReplacedString(EGLCodeTemplate.mdd_sql_recordHeader, ctx.getVariables()));
        recordsDef.append(this.getEntityRecordHeader(table, ctx));
        Object[] objectArray = columns = table.getColumns().toArray();
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            column = objectArray[n2];
            ctx.invoke("genEntityRecordColumn", column, new Object[]{ctx, recordsDef});
            ++n2;
        }
        recordsDef.append(this.getRecordFooter());
        recordsDef.append(this.getSearchRecordHeader(table, ctx));
        objectArray = columns;
        n = columns.length;
        n2 = 0;
        while (n2 < n) {
            column = objectArray[n2];
            ctx.invoke("genSearchRecordColumn", column, new Object[]{ctx, recordsDef});
            ++n2;
        }
        recordsDef.append(this.getRecordFooter());
        recordsDef.append(DataToolsObjectsToEGLUtils.getReplacedString(EGLCodeTemplate.mdd_statusRecord, variable));
        ctx.getSourceFileContentTable().put(filePath, recordsDef.toString());
    }

    protected String getSearchRecordName(Table table) {
        return String.valueOf(this.getEntityRecordName(table)) + "Search";
    }

    protected String getSearchRecordHeader(Table table, EglSourceContext ctx) {
        return "record " + this.getSearchRecordName(table);
    }

    @Override
    public void genObject(Table object, EglSourceContext ctx) {
        if (object instanceof Table) {
            this.genTable(object, ctx);
        }
    }
}

