/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.internal.EGLBasePlugin;
import org.eclipse.edt.ide.core.internal.search.PartDeclarationInfo;
import org.eclipse.edt.ide.core.internal.search.PartInfoRequestor;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPart;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;
import org.eclipse.edt.ide.core.search.IPartNameRequestor;
import org.eclipse.edt.ide.core.search.SearchEngine;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.Deployment;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentPackage;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentProject;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentTarget;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Parameter;
import org.eclipse.edt.ide.ui.internal.deployment.Parameters;
import org.eclipse.edt.ide.ui.internal.deployment.Resource;
import org.eclipse.edt.ide.ui.internal.deployment.ResourceOmissions;
import org.eclipse.edt.ide.ui.internal.deployment.Service;
import org.eclipse.edt.ide.ui.internal.deployment.Services;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class EGLDDRootHelper {
    public static final int PORT_MAXVALUE = 65536;
    public static final String EXTENSION_EGLDD = "egldd";
    private static HashMap fSharedModuleModel;

    private static void persistEGLDDFile(IFile eglBindFile, EGLDeploymentRoot documentRoot) throws IOException {
        org.eclipse.emf.ecore.resource.Resource savedResource;
        URI uri = URI.createPlatformResourceURI((String)eglBindFile.getFullPath().toOSString(), (boolean)true);
        org.eclipse.emf.ecore.resource.Resource resource = savedResource = documentRoot.eResource();
        HashMap<String, String> options = Collections.EMPTY_MAP;
        if (!savedResource.getURI().equals((Object)uri)) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            resource = resourceSet.createResource(uri);
            String encoding = EGLBasePlugin.getPlugin().getPreferenceStore().getString("outputCodeset");
            if (encoding != null && encoding.length() > 0) {
                options = new HashMap<String, String>();
                options.put("ENCODING", encoding);
            }
        }
        resource.getContents().add((Object)documentRoot);
        resource.save((Map)options);
    }

    public static void releaseSharedWorkingModel(IFile moduleFile, boolean isUserClient) {
        String moduleFilePathString;
        Object obj;
        if (fSharedModuleModel != null && (obj = fSharedModuleModel.get(moduleFilePathString = moduleFile.getFullPath().toOSString())) != null) {
            EGLDDFileInfo fileinfo = (EGLDDFileInfo)obj;
            if (isUserClient) {
                if (fileinfo.userClientCount > 0) {
                    --fileinfo.userClientCount;
                }
            } else if (fileinfo.actionClientCount > 0) {
                --fileinfo.actionClientCount;
            }
            if (fileinfo.actionClientCount + fileinfo.userClientCount == 0) {
                fSharedModuleModel.remove(moduleFilePathString);
            }
        }
    }

    public static boolean isWorkingModelSharedByUserClients(IFile moduleFile) {
        String moduleFilePathString;
        Object obj;
        if (fSharedModuleModel != null && (obj = fSharedModuleModel.get(moduleFilePathString = moduleFile.getFullPath().toOSString())) != null) {
            EGLDDFileInfo fileinfo = (EGLDDFileInfo)obj;
            if (fileinfo.userClientCount > 0) {
                return true;
            }
        }
        return false;
    }

    public static EGLDeploymentRoot getEGLDDFileSharedWorkingModel(IFile serviceBindFile, ResourceSet resourceSet, boolean isUserClient) {
        String serviceBindFilePathString;
        Object obj;
        EGLDDFileInfo eglbindfileinfo = null;
        if (fSharedModuleModel == null) {
            fSharedModuleModel = new HashMap();
        }
        if ((obj = fSharedModuleModel.get(serviceBindFilePathString = serviceBindFile.getFullPath().toOSString())) == null) {
            URI uri = URI.createPlatformResourceURI((String)serviceBindFile.getFullPath().toOSString(), (boolean)true);
            org.eclipse.emf.ecore.resource.Resource resource = resourceSet.getResource(uri, true);
            EGLDeploymentRoot serviceBindRoot = (EGLDeploymentRoot)resource.getContents().get(0);
            eglbindfileinfo = new EGLDDFileInfo();
            eglbindfileinfo.serviceBindingRoot = serviceBindRoot;
            fSharedModuleModel.put(serviceBindFilePathString, eglbindfileinfo);
        } else {
            eglbindfileinfo = (EGLDDFileInfo)obj;
        }
        if (isUserClient) {
            ++eglbindfileinfo.userClientCount;
        } else {
            ++eglbindfileinfo.actionClientCount;
        }
        return eglbindfileinfo.serviceBindingRoot;
    }

    public static EGLDeploymentRoot getEGLDDFileSharedWorkingModel(IFile serviceBindFile, boolean isUserClient) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        if (serviceBindFile != null && serviceBindFile.exists()) {
            return EGLDDRootHelper.getEGLDDFileSharedWorkingModel(serviceBindFile, (ResourceSet)resourceSet, isUserClient);
        }
        return null;
    }

    public static void createNewEGLDDFile(IFile eglBindFile, String encoding) {
        EGLDeploymentRoot documentRoot = DeploymentFactory.eINSTANCE.createEGLDeploymentRoot();
        Deployment root = DeploymentFactory.eINSTANCE.createDeployment();
        documentRoot.setDeployment(root);
        try {
            URI uri = URI.createPlatformResourceURI((String)eglBindFile.getFullPath().toOSString(), (boolean)true);
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            org.eclipse.emf.ecore.resource.Resource resource = resourceSet.createResource(uri);
            resource.getContents().add((Object)documentRoot);
            if (encoding != null && encoding.length() > 0) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("ENCODING", encoding);
                resource.save(options);
            } else {
                resource.save(null);
            }
        }
        catch (IOException exception) {
            EDTUIPlugin.log(exception);
        }
    }

    public static void saveEGLDDFile(IFile eglBindFile, EGLDeploymentRoot documentRoot) {
        try {
            EGLDDRootHelper.persistEGLDDFile(eglBindFile, documentRoot);
        }
        catch (IOException exception) {
            EDTUIPlugin.log(exception);
        }
    }

    public static IFile findPartFile(String fullyqualifiedPartName, IEGLProject eglProj) {
        try {
            PartDeclarationInfo part = EGLDDRootHelper.find1stPartInfoInEGLProject(fullyqualifiedPartName, eglProj, Short.MAX_VALUE, null, true);
            if (part != null) {
                return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(part.getPath()));
            }
        }
        catch (CoreException e) {
            EDTUIPlugin.log(e);
            return null;
        }
        return null;
    }

    public static IPart findPartInEGLProject(String fullyqualifiedPartName, IEGLProject eglProj) throws EGLModelException {
        IPart part = eglProj.findPart(fullyqualifiedPartName);
        if (part == null) {
            String[] refProjNames = eglProj.getRequiredProjectNames();
            IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
            int i = 0;
            while (i < refProjNames.length && part == null) {
                eglProj = EGLCore.create((IProject)workspaceRoot.getProject(refProjNames[i]));
                part = eglProj.findPart(fullyqualifiedPartName);
                ++i;
            }
        }
        return part;
    }

    public static PartDeclarationInfo find1stPartInfoInEGLProject(String fullyqualifiedPartName, IEGLProject eglProj, int partKind, IProgressMonitor monitor, boolean includeReferencedProjects) throws EGLModelException {
        int lastdot = fullyqualifiedPartName.lastIndexOf(46);
        String pkgName = "";
        String partSimpleName = fullyqualifiedPartName;
        if (lastdot != -1) {
            pkgName = fullyqualifiedPartName.substring(0, lastdot);
            partSimpleName = fullyqualifiedPartName.substring(lastdot + 1);
        }
        IEGLSearchScope projScope = SearchEngine.createEGLSearchScope((IEGLElement[])new IEGLElement[]{eglProj}, (boolean)true);
        ArrayList typeList = new ArrayList();
        new SearchEngine().searchAllPartNames(ResourcesPlugin.getWorkspace(), pkgName.toCharArray(), partSimpleName.toCharArray(), 0, false, partKind, projScope, (IPartNameRequestor)new PartInfoRequestor(typeList), 3, monitor);
        int foundCnts = typeList.size();
        if (foundCnts > 0) {
            PartDeclarationInfo foundPart = (PartDeclarationInfo)typeList.get(0);
            return foundPart;
        }
        return null;
    }

    public static Binding getBindingByName(EGLDeploymentRoot root, String name) {
        Deployment deployment;
        Bindings bindings;
        if (root != null && (bindings = (deployment = root.getDeployment()).getBindings()) != null) {
            for (Binding binding : bindings.getBinding()) {
                if (!name.equals(binding.getName())) continue;
                return binding;
            }
        }
        return null;
    }

    public static Service getServiceByImpl(EGLDeploymentRoot root, String impl) {
        Deployment deployment = root.getDeployment();
        Services services = deployment.getServices();
        if (services != null) {
            for (Service service : services.getService()) {
                if (!impl.equals(service.getImplementation())) continue;
                return service;
            }
        }
        return null;
    }

    public static DeploymentTarget getDeploymentTarget(EGLDeploymentRoot root) {
        return root.getDeployment().getTarget();
    }

    public static String getTargetName(EGLDeploymentRoot root) {
        DeploymentTarget target = root.getDeployment().getTarget();
        if (target == null) {
            return "";
        }
        return target.getName();
    }

    public static void setTarget(DeploymentTarget target, EGLDeploymentRoot root) {
        EGLDDRootHelper.removeTarget(root);
        if (target instanceof DeploymentProject) {
            root.getDeployment().getTargetGroup().add((EStructuralFeature)DeploymentPackage.eINSTANCE.getEGLDeploymentRoot_TargetProject(), (Object)target);
        }
    }

    public static void removeTarget(EGLDeploymentRoot root) {
        root.getDeployment().getTargetGroup().clear();
    }

    public static Parameters getParameters(Binding binding) {
        Parameters p = binding.getParameters();
        if (p == null) {
            p = DeploymentFactory.eINSTANCE.createParameters();
            binding.setParameters(p);
        }
        return p;
    }

    public static Parameters getParameters(Service service) {
        Parameters p = service.getParameters();
        if (p == null) {
            p = DeploymentFactory.eINSTANCE.createParameters();
            service.setParameters(p);
        }
        return p;
    }

    public static void addOrUpdateParameter(Parameters parms, String name, boolean value) {
        EGLDDRootHelper.addOrUpdateParameter(parms, name, String.valueOf(value));
    }

    public static void addOrUpdateParameter(Parameters parms, String name, char value) {
        EGLDDRootHelper.addOrUpdateParameter(parms, name, String.valueOf(value));
    }

    public static void addOrUpdateParameter(Parameters parms, String name, int value) {
        EGLDDRootHelper.addOrUpdateParameter(parms, name, String.valueOf(value));
    }

    public static void addOrUpdateParameter(Parameters parms, String name, String value) {
        boolean found = false;
        for (Parameter p : parms.getParameter()) {
            if (!p.getName().equals(name)) continue;
            if (value == null || value.length() == 0) {
                parms.getParameter().remove((Object)p);
            } else {
                p.setValue(value);
            }
            found = true;
            break;
        }
        if (!found && value != null && value.length() != 0) {
            Parameter p = DeploymentFactory.eINSTANCE.createParameter();
            p.setName(name);
            p.setValue(value);
            parms.getParameter().add((Object)p);
        }
    }

    public static boolean getBooleanParameterValue(Parameters parms, String name) {
        return Boolean.parseBoolean(EGLDDRootHelper.getParameterValue(parms, name));
    }

    public static String getParameterValue(Parameters parms, String name) {
        if (parms != null) {
            for (Parameter p : parms.getParameter()) {
                if (!p.getName().equals(name)) continue;
                String value = p.getValue();
                if (value == null) {
                    return "";
                }
                return value;
            }
        }
        return "";
    }

    public static void processResourceOmissionChanges(EGLDeploymentRoot root, List omissionsToAdd, List omissionsToRemove) {
        ResourceOmissions omissions = root.getDeployment().getResourceOmissions();
        if (omissions == null && omissionsToAdd.size() > 0) {
            omissions = DeploymentFactory.eINSTANCE.createResourceOmissions();
            root.getDeployment().setResourceOmissions(omissions);
        }
        if (omissions != null) {
            Iterator it = omissions.getResource().iterator();
            while (it.hasNext()) {
                String nextResource = ((Resource)it.next()).getId();
                if (omissionsToAdd.contains(nextResource)) {
                    omissionsToAdd.remove(nextResource);
                    continue;
                }
                if (!omissionsToRemove.contains(nextResource)) continue;
                it.remove();
            }
            EList omissionList = omissions.getResource();
            Iterator it2 = omissionsToAdd.iterator();
            while (it2.hasNext()) {
                Resource resource = DeploymentFactory.eINSTANCE.createResource();
                resource.setId((String)it2.next());
                omissionList.add((Object)resource);
            }
            if (omissionList.size() == 0) {
                root.getDeployment().setResourceOmissions(null);
            }
        }
    }

    public static List getResourceOmissionsAsStrings(EGLDeploymentRoot root) {
        ResourceOmissions omissions = root.getDeployment().getResourceOmissions();
        if (omissions == null) {
            return null;
        }
        EList omissionList = omissions.getResource();
        ArrayList<String> asStrings = new ArrayList<String>(omissionList.size());
        Iterator it = omissionList.iterator();
        while (it.hasNext()) {
            asStrings.add(((Resource)it.next()).getId());
        }
        return asStrings;
    }

    public static String getValidURI(Deployment deployment, String uriPrefix) {
        Services services = deployment.getServices();
        int maxSuffix = -1;
        for (Service ser : services.getService()) {
            String uriValue = EGLDDRootHelper.getParameterValue(ser.getParameters(), "uriFragment");
            if (uriValue == null) continue;
            if (maxSuffix < 0 && uriValue.equals(uriPrefix)) {
                maxSuffix = 0;
                continue;
            }
            if (!uriValue.startsWith(uriPrefix)) continue;
            String suffixStr = uriValue.substring(uriPrefix.length());
            try {
                int index = Integer.parseInt(suffixStr);
                if (index <= maxSuffix) continue;
                maxSuffix = index;
            }
            catch (Exception exception) {}
        }
        if (maxSuffix < 0) {
            return uriPrefix;
        }
        return String.valueOf(uriPrefix) + (maxSuffix + 1);
    }

    private static class EGLDDFileInfo {
        public EGLDeploymentRoot serviceBindingRoot = null;
        public int actionClientCount = 0;
        public int userClientCount = 0;

        private EGLDDFileInfo() {
        }
    }
}

