/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.deployment.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.provider.DeploymentItemProviderAdapterFactory;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDBindingFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDImportsFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDOverviewFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDResourcesFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDWebsServicesFormPage;
import org.eclipse.edt.ide.ui.internal.deployment.ui.IEGLDDContributionPageProvider;
import org.eclipse.edt.ide.ui.internal.deployment.ui.IEGLDDContributionToolbarProvider;
import org.eclipse.edt.ide.ui.internal.deployment.ui.SOAMessages;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class EGLDeploymentDescriptorEditor
extends FormEditor
implements IEditingDomainProvider,
IResourceChangeListener {
    public static final String PAGEID_OVERVIEW = "page.eglbind.overview";
    public static final String PAGEID_BINDINGS = "page.eglbind.bindings";
    public static final String PAGEID_WEBSERVICES = "page.eglbind.webservices";
    public static final String PAGEID_PROTOCOLS = "page.eglbind.protocols";
    public static final String PAGEID_TARGETS = "page.eglbind.targets";
    public static final String PAGEID_IMPORTS = "page.eglbind.imports";
    public static final String PAGEID_RESOURCES = "page.eglbind.resources";
    private static final String EXTENSIONPOINT_DD_EDITOR_PAGE_CONTRIBUTIONS = "org.eclipse.edt.ide.ui.eglDDEditorPageContributions";
    private static final String EXTENSIONPOINT_DD_EDITOR_TOOLBAR_CONTRIBUTIONS = "org.eclipse.edt.ide.ui.eglDDEditorToolbarContributions";
    private static IEGLDDContributionPageProvider[] editorProviders;
    private static IEGLDDContributionToolbarProvider[] toolbarProviders;
    private AdapterFactoryEditingDomain editingDomain;
    private EGLDeploymentRoot fServiceBindingRoot;
    private boolean fModelChanged;
    private EGLServiceBindResourceObserver fServiceBindResourceObserver;
    public static final Point SMALL_SIZE;
    private EGLDDOverviewFormPage overviewFormPage;

    static {
        SMALL_SIZE = new Point(16, 16);
    }

    public EGLDeploymentDescriptorEditor() {
        this.initEditingDomain();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(input.getName());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    private void initEditingDomain() {
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new DeploymentItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(factories);
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                EGLDeploymentDescriptorEditor.this.getContainer().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EGLDeploymentDescriptorEditor.this.editorDirtyStateChanged();
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
    }

    protected void addPages() {
        try {
            this.overviewFormPage = new EGLDDOverviewFormPage(this, PAGEID_OVERVIEW, SOAMessages.OverviewPageLabel);
            this.addPage((IFormPage)this.overviewFormPage);
            this.addPageContributions();
            this.addPage((IFormPage)new EGLDDWebsServicesFormPage(this, PAGEID_WEBSERVICES, SOAMessages.WebServicePageLabel));
            this.addPage((IFormPage)new EGLDDBindingFormPage(this, PAGEID_BINDINGS, SOAMessages.BindingPageLabel));
            this.addPage((IFormPage)new EGLDDImportsFormPage(this, PAGEID_IMPORTS, SOAMessages.ImportPageLabel));
            this.addPage((IFormPage)new EGLDDResourcesFormPage(this, PAGEID_RESOURCES, SOAMessages.ArtifactsTitle));
        }
        catch (PartInitException e) {
            EDTUIPlugin.log(e);
        }
    }

    private void addPageContributions() {
        IEGLDDContributionPageProvider[] providers = EGLDeploymentDescriptorEditor.getEditorProviders();
        int i = 0;
        while (i < providers.length) {
            try {
                this.addPage((IFormPage)providers[i].createPage(this));
            }
            catch (PartInitException pie) {
                EDTUIPlugin.log(pie);
            }
            ++i;
        }
    }

    public static IEGLDDContributionPageProvider[] getEditorProviders() {
        if (editorProviders == null) {
            ArrayList<Object> providers = new ArrayList<Object>();
            IConfigurationElement[] editorContributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONPOINT_DD_EDITOR_PAGE_CONTRIBUTIONS);
            if (editorContributions != null) {
                int i = 0;
                while (i < editorContributions.length) {
                    try {
                        Object o = editorContributions[i].createExecutableExtension("class");
                        if (o instanceof IEGLDDContributionPageProvider) {
                            providers.add(o);
                        }
                    }
                    catch (CoreException ce) {
                        EDTUIPlugin.log(ce);
                    }
                    ++i;
                }
            }
            editorProviders = providers.toArray(new IEGLDDContributionPageProvider[providers.size()]);
        }
        return editorProviders;
    }

    public static IEGLDDContributionToolbarProvider[] getToolbarProviders() {
        if (toolbarProviders == null) {
            ArrayList<Object> providers = new ArrayList<Object>();
            IConfigurationElement[] editorContributions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONPOINT_DD_EDITOR_TOOLBAR_CONTRIBUTIONS);
            if (editorContributions != null) {
                int i = 0;
                while (i < editorContributions.length) {
                    try {
                        Object o = editorContributions[i].createExecutableExtension("class");
                        if (o instanceof IEGLDDContributionToolbarProvider) {
                            providers.add(o);
                        }
                    }
                    catch (CoreException ce) {
                        EDTUIPlugin.log(ce);
                    }
                    ++i;
                }
            }
            toolbarProviders = providers.toArray(new IEGLDDContributionToolbarProvider[providers.size()]);
        }
        return toolbarProviders;
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            Resource savedResource = this.getModelRoot().eResource();
            savedResource.save(Collections.EMPTY_MAP);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.fModelChanged = false;
            this.editorDirtyStateChanged();
        }
        catch (Exception exception) {
            EDTUIPlugin.log(exception);
        }
    }

    public boolean isDirty() {
        return this.fModelChanged || super.isDirty();
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public EGLDeploymentRoot getModelRoot() {
        if (this.fServiceBindingRoot == null) {
            ResourceSet resourceSet = this.editingDomain.getResourceSet();
            IEditorInput editorInput = this.getEditorInput();
            if (editorInput instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)editorInput;
                IFile file = fileInput.getFile();
                this.fServiceBindingRoot = EGLDDRootHelper.getEGLDDFileSharedWorkingModel(file, resourceSet, true);
                this.fServiceBindResourceObserver = new EGLServiceBindResourceObserver();
                this.fServiceBindingRoot.eResource().eAdapters().add((Object)this.fServiceBindResourceObserver);
            }
        }
        return this.fServiceBindingRoot;
    }

    public void dispose() {
        IFile file = this.getEditorInputFile();
        if (file != null) {
            this.fServiceBindingRoot.eResource().eAdapters().remove((Object)this.fServiceBindResourceObserver);
            EGLDDRootHelper.releaseSharedWorkingModel(file, true);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    protected FormToolkit createToolkit(Display display) {
        return new FormToolkit(EDTUIPlugin.getDefault().getFormColors(display));
    }

    protected IProject getProject() {
        IFile file = this.getEditorInputFile();
        if (file != null) {
            return file.getProject();
        }
        return null;
    }

    protected IFile getEditorInputFile() {
        IEditorInput editorInput = this.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)editorInput;
            IFile file = fileInput.getFile();
            return file;
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResource eventRes = event.getResource();
        switch (event.getType()) {
            case 2: {
                if (((IProject)eventRes).findMember(this.getEditorInputFile().getProjectRelativePath()) == null) break;
                this.close(false);
                break;
            }
            case 4: {
                if (((IProject)eventRes).findMember(this.getEditorInputFile().getProjectRelativePath()) == null) break;
                this.close(false);
                break;
            }
            case 8: {
                break;
            }
            case 16: {
                break;
            }
            case 1: {
                try {
                    event.getDelta().accept(new IResourceDeltaVisitor(){

                        public boolean visit(IResourceDelta delta) throws CoreException {
                            IResource res = delta.getResource();
                            switch (delta.getKind()) {
                                case 1: {
                                    if (res.getType() != 4) break;
                                    EGLDeploymentDescriptorEditor.this.updateTargetList((IProject)res);
                                    break;
                                }
                                case 4: {
                                    break;
                                }
                                case 2: {
                                    if (res.equals((Object)EGLDeploymentDescriptorEditor.this.getEditorInputFile())) {
                                        EGLDeploymentDescriptorEditor.this.close(false);
                                        break;
                                    }
                                    if (res.getType() != 4) break;
                                    EGLDeploymentDescriptorEditor.this.updateTargetList((IProject)res);
                                }
                            }
                            return true;
                        }
                    });
                    break;
                }
                catch (CoreException e) {
                    EDTUIPlugin.log(e);
                }
            }
        }
    }

    private void updateTargetList(IProject project) {
        Display display;
        if (this.overviewFormPage != null && (display = this.getSite().getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EGLDeploymentDescriptorEditor.this.overviewFormPage.initTargets();
                }
            });
        }
    }

    public void setFocus() {
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        }
    }

    protected class EGLServiceBindResourceObserver
    implements Adapter {
        protected EGLServiceBindResourceObserver() {
        }

        public void notifyChanged(Notification notification) {
            EGLDeploymentDescriptorEditor.this.fModelChanged = true;
            Display display = EGLDeploymentDescriptorEditor.this.getSite().getShell().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    EGLDeploymentDescriptorEditor.this.firePropertyChange(257);
                }
            });
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return false;
        }
    }
}

