/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.Locale;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public abstract class AbstractCodeScanner
extends BufferedRuleBasedScanner {
    protected static IRule[] result;

    class EGLWhitespaceDetector
    implements IWhitespaceDetector {
        EGLWhitespaceDetector() {
        }

        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }

    class EGLWordDetector
    implements IWordDetector {
        EGLWordDetector() {
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c) || c == '-' || c == '#' || c == '@';
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }
    }

    class EGLWordRule
    extends WordRule {
        public EGLWordRule(IWordDetector detector) {
            super(detector);
        }

        public EGLWordRule(IWordDetector detector, IToken defaultToken) {
            super(detector, defaultToken);
        }

        public IToken evaluate(ICharacterScanner scanner) {
            StringBuffer eglBuffer = new StringBuffer();
            int c = scanner.read();
            if (this.fDetector.isWordStart((char)c) && (this.fColumn == -1 || this.fColumn == scanner.getColumn() - 1)) {
                eglBuffer.setLength(0);
                do {
                    eglBuffer.append((char)c);
                } while ((c = scanner.read()) != -1 && this.fDetector.isWordPart((char)c));
                scanner.unread();
                IToken token = (IToken)this.fWords.get(eglBuffer.toString().toLowerCase(Locale.ENGLISH));
                if (token != null) {
                    return token;
                }
                if (this.fDefaultToken.isUndefined()) {
                    this.unreadBuffer(scanner);
                }
                return this.fDefaultToken;
            }
            scanner.unread();
            return Token.UNDEFINED;
        }
    }
}

