/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.edt.ide.ui.internal.editor.HoverUtils;
import org.eclipse.edt.ide.ui.internal.editor.IAnnotation;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;

public class AnnotationHover
implements IAnnotationHover {
    protected int compareRulerLine(Position position, IDocument document, int line) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            int javaAnnotationLine;
            block5: {
                try {
                    javaAnnotationLine = document.getLineOfOffset(position.getOffset());
                    if (line != javaAnnotationLine) break block5;
                    return 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            if (javaAnnotationLine <= line && line <= document.getLineOfOffset(position.getOffset() + position.getLength())) {
                return 2;
            }
        }
        return 0;
    }

    protected List select(List exactMatch, List including) {
        return exactMatch;
    }

    protected List getEGLAnnotationsForLine(ISourceViewer viewer, int line) {
        IDocument document = viewer.getDocument();
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return null;
        }
        ArrayList<IAnnotation> exact = new ArrayList<IAnnotation>();
        ArrayList<IAnnotation> including = new ArrayList<IAnnotation>();
        ArrayList eglAnnotations = new ArrayList();
        Iterator e = model.getAnnotationIterator();
        while (e.hasNext()) {
            eglAnnotations.add(e.next());
        }
        HoverUtils.sort(eglAnnotations);
        HashMap messagesAtPosition = new HashMap();
        for (Object o : eglAnnotations) {
            IAnnotation a;
            Position position;
            if (!(o instanceof IAnnotation) || (position = model.getPosition((Annotation)(a = (IAnnotation)o))) == null || HoverUtils.isDuplicateAnnotation(messagesAtPosition, position, a)) continue;
            switch (this.compareRulerLine(position, document, line)) {
                case 1: {
                    exact.add(a);
                    break;
                }
                case 2: {
                    including.add(a);
                }
            }
        }
        return this.select(exact, including);
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        List eglAnnotations = this.getEGLAnnotationsForLine(sourceViewer, lineNumber);
        if (eglAnnotations != null) {
            if (eglAnnotations.size() == 1) {
                IAnnotation eglAnnotation = (IAnnotation)eglAnnotations.get(0);
                String message = eglAnnotation.getText();
                if (message != null && message.trim().length() > 0) {
                    return HoverUtils.formatSingleMessage(message);
                }
            } else {
                ArrayList<String> messages = new ArrayList<String>();
                for (IAnnotation eglAnnotation : eglAnnotations) {
                    String message = eglAnnotation.getText();
                    if (message == null || message.trim().length() <= 0) continue;
                    messages.add(message.trim());
                }
                if (messages.size() == 1) {
                    return HoverUtils.formatSingleMessage((String)messages.get(0));
                }
                if (messages.size() > 1) {
                    return HoverUtils.formatMultipleMessages(messages);
                }
            }
        }
        return null;
    }
}

