/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.editor.sql;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.edt.compiler.core.ast.AbstractASTVisitor;
import org.eclipse.edt.compiler.core.ast.AddStatement;
import org.eclipse.edt.compiler.core.ast.CloseStatement;
import org.eclipse.edt.compiler.core.ast.DeleteStatement;
import org.eclipse.edt.compiler.core.ast.ExecuteStatement;
import org.eclipse.edt.compiler.core.ast.ForExpressionClause;
import org.eclipse.edt.compiler.core.ast.ForUpdateClause;
import org.eclipse.edt.compiler.core.ast.GetByKeyStatement;
import org.eclipse.edt.compiler.core.ast.GetByPositionStatement;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.IntoClause;
import org.eclipse.edt.compiler.core.ast.NoCursorClause;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.OpenStatement;
import org.eclipse.edt.compiler.core.ast.ReplaceStatement;
import org.eclipse.edt.compiler.core.ast.Statement;
import org.eclipse.edt.compiler.core.ast.UsingClause;
import org.eclipse.edt.compiler.core.ast.UsingKeysClause;
import org.eclipse.edt.compiler.core.ast.WithIDClause;
import org.eclipse.edt.compiler.core.ast.WithInlineSQLClause;
import org.eclipse.edt.compiler.internal.core.lookup.DefaultCompilerOptions;
import org.eclipse.edt.compiler.internal.core.lookup.ICompilerOptions;
import org.eclipse.edt.compiler.internal.util.BindingUtil;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.internal.editor.sql.SQLIOStatementActionInfo;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.ArrayType;
import org.eclipse.edt.mof.egl.Field;
import org.eclipse.edt.mof.egl.LogicAndDataPart;
import org.eclipse.edt.mof.egl.Member;
import org.eclipse.edt.mof.egl.Part;
import org.eclipse.edt.mof.egl.Record;
import org.eclipse.edt.mof.egl.Type;
import org.eclipse.edt.mof.egl.utils.TypeUtils;
import org.eclipse.edt.mof.eglx.persistence.sql.ext.Utils;

public class SQLIOStatementUtility {
    public static SQLIOStatementActionInfo getAddSQLIoStatementActionInfo(IEGLDocument document, Node node) {
        SQLIOStatementActionInfo info = new SQLIOStatementActionInfo();
        info.setDocument(document);
        if (node == null) {
            return info;
        }
        try {
            SQLIOStatementUtility.setupActionInfo(node, info);
        }
        catch (Exception e) {
            e.printStackTrace();
            EGLLogger.log(SQLIOStatementUtility.class, e);
        }
        return info;
    }

    private static SQLIOStatementActionInfo setupActionInfo(Node node, final SQLIOStatementActionInfo info) {
        ICompilerOptions compileOptions = DefaultCompilerOptions.getInstance();
        info.setCompilerOption(compileOptions);
        if (node instanceof AddStatement) {
            AddStatement addStatement = (AddStatement)node;
            info.setIOType("add".toUpperCase());
            info.setStatement((Statement)addStatement);
            addStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    return false;
                }
            });
        } else if (node instanceof ExecuteStatement) {
            ExecuteStatement executeStatement = (ExecuteStatement)node;
            info.setStatement((Statement)executeStatement);
            info.setIOType("execute".toUpperCase());
        } else if (node instanceof GetByKeyStatement) {
            GetByKeyStatement getStatement = (GetByKeyStatement)node;
            getStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(ForUpdateClause forUpdate) {
                    info.setIOType("get forUpdate".toUpperCase());
                    return false;
                }

                public boolean visit(WithIDClause prepareID) {
                    info.setHasPreparedStatementReference(true);
                    return false;
                }

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    return false;
                }

                public boolean visit(IntoClause intoClause) {
                    info.setIntoClauseNode((Node)intoClause);
                    return false;
                }

                public boolean visit(UsingKeysClause keysClause) {
                    info.setUsingKeysNode((Node)keysClause);
                    return false;
                }

                public boolean visit(UsingClause keysClause) {
                    info.setUsingExisted(true);
                    return false;
                }
            });
            if (info.getIOType() == null) {
                info.setIOType("get".toUpperCase());
            }
            info.setStatement((Statement)getStatement);
        } else if (node instanceof OpenStatement) {
            OpenStatement openStatement = (OpenStatement)node;
            info.setStatement((Statement)openStatement);
            openStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(ForUpdateClause forUpdate) {
                    info.setIOType("open forUpdate".toUpperCase());
                    return false;
                }

                public boolean visit(ForExpressionClause forExpressionClause) {
                    info.setForExpressionClause((Node)forExpressionClause);
                    return false;
                }

                public boolean visit(WithIDClause prepareID) {
                    info.setShouldAddSQLStatement(false);
                    info.setHasPreparedStatementReference(true);
                    return false;
                }

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setShouldAddSQLStatement(false);
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    return false;
                }

                public boolean visit(IntoClause intoClause) {
                    info.setIntoClauseNode((Node)intoClause);
                    return false;
                }

                public boolean visit(UsingClause keysClause) {
                    info.setUsingExisted(true);
                    return false;
                }
            });
            if (info.getIOType() == null) {
                info.setIOType("open".toUpperCase());
            }
        } else if (node instanceof ReplaceStatement) {
            ReplaceStatement replaceStatement = (ReplaceStatement)node;
            info.setIOType("replace".toUpperCase());
            info.setStatement((Statement)replaceStatement);
            replaceStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    return false;
                }

                public boolean visit(NoCursorClause noCursor) {
                    info.setNoCursor(true);
                    return false;
                }
            });
        } else if (node instanceof GetByPositionStatement) {
            GetByPositionStatement getByPositionStatement = (GetByPositionStatement)node;
            info.setIOType("get by position".toUpperCase());
            if (getByPositionStatement.isNextDirection()) {
                info.setGetNext(true);
            }
            info.setStatement((Statement)getByPositionStatement);
            getByPositionStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(IntoClause intoClause) {
                    info.setIntoClauseNode((Node)intoClause);
                    return false;
                }
            });
        } else if (node instanceof CloseStatement) {
            info.setIOType("close".toUpperCase());
            info.setStatement((Statement)((CloseStatement)node));
        } else if (node instanceof DeleteStatement) {
            DeleteStatement deleteStatement = (DeleteStatement)node;
            info.setIOType("delete".toUpperCase());
            info.setStatement((Statement)deleteStatement);
            deleteStatement.accept((IASTVisitor)new AbstractASTVisitor(){

                public boolean visit(WithInlineSQLClause inlineSQL) {
                    info.setSqlStatement(inlineSQL.getSqlStmt().getValue());
                    info.setSqlStatementNode((Node)inlineSQL);
                    return false;
                }

                public boolean visit(NoCursorClause noCursor) {
                    info.setNoCursor(true);
                    return false;
                }
            });
        }
        return info;
    }

    public static boolean isEntityRecord(Type typeBinding) {
        while (typeBinding instanceof ArrayType) {
            typeBinding = ((ArrayType)typeBinding).getElementType();
        }
        if (typeBinding != null) {
            return typeBinding.getAnnotation("eglx.persistence.Entity") != null;
        }
        return false;
    }

    public static boolean isBasicRecord(Type typeBinding) {
        while (typeBinding instanceof ArrayType) {
            typeBinding = ((ArrayType)typeBinding).getElementType();
        }
        return typeBinding instanceof Record;
    }

    public static boolean getIsReadOnly(Field field) {
        return Utils.isGeneratedValue((Field)field) || !Utils.isInsertable((Field)field);
    }

    public static boolean getIsUpdateable(Field field) {
        return Utils.isUpdateable((Field)field);
    }

    public static boolean containsOnlyKeyOrReadOnlyColumns(Type sqlRecordType, List<Field> recordKeyItems) {
        if (!(sqlRecordType instanceof LogicAndDataPart)) {
            return false;
        }
        List sqlDataItems = ((LogicAndDataPart)sqlRecordType).getFields();
        int i = 0;
        while (i < sqlDataItems.size()) {
            Field itemBinding = (Field)sqlDataItems.get(i);
            if (!SQLIOStatementUtility.getIsReadOnly(itemBinding) && !recordKeyItems.contains(itemBinding)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsOnlyKeyOrReadOnlyColumns(Type sqlRecordType, String[][] usingKeyItemAndColumnNames) {
        if (!(sqlRecordType instanceof LogicAndDataPart)) {
            return false;
        }
        List sqlDataItems = ((LogicAndDataPart)sqlRecordType).getFields();
        int i = 0;
        while (i < sqlDataItems.size()) {
            Field itemBinding = (Field)sqlDataItems.get(i);
            if (!SQLIOStatementUtility.getIsReadOnly(itemBinding) && !SQLIOStatementUtility.isUsingKeyColumn(itemBinding, usingKeyItemAndColumnNames, sqlRecordType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUsingKeyColumn(Field field, String[][] usingKeyItemAndColumnNames, Type recordType) {
        int i = 0;
        while (i < usingKeyItemAndColumnNames.length) {
            if (Utils.getColumnName((Field)field).equalsIgnoreCase(usingKeyItemAndColumnNames[i][1])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getIdColumnName(Type type) {
        if (type instanceof LogicAndDataPart) {
            for (Field field : ((LogicAndDataPart)type).getFields()) {
                if (!Utils.isKeyField((Field)field)) continue;
                return Utils.getColumnName((Field)field);
            }
        }
        return null;
    }

    public static String getTableName(Type typeBinding) {
        Annotation annotation;
        if (typeBinding != null && (annotation = typeBinding.getAnnotation("eglx.persistence.sql.Table")) != null) {
            return (String)annotation.getValue("name");
        }
        return null;
    }

    public static Map<Type, String> getForeignKeys(Member dataBinding, Type typeBinding) {
        if (!(typeBinding instanceof LogicAndDataPart)) {
            return null;
        }
        HashMap<Part, String> foreignKeys = null;
        List fieldBindings = ((LogicAndDataPart)typeBinding).getFields();
        for (Field fieldBinding : fieldBindings) {
            String foreignKey = SQLIOStatementUtility.getForeignKeyName(fieldBinding);
            if (foreignKey == null) continue;
            if (foreignKeys == null) {
                foreignKeys = new HashMap<Part, String>();
            }
            if (TypeUtils.isPrimitive((Type)fieldBinding.getType())) {
                foreignKeys.put(BindingUtil.getDeclaringPart((Member)dataBinding), foreignKey);
                continue;
            }
            foreignKeys.put(BindingUtil.getDeclaringPart((Member)fieldBinding), foreignKey);
        }
        return foreignKeys;
    }

    private static String getForeignKeyName(Field fieldBinding) {
        String columnName = null;
        Annotation annotation = fieldBinding.getAnnotation("eglx.persistence.ManyToOne");
        if (annotation != null) {
            columnName = fieldBinding.getCaseSensitiveName();
        }
        return columnName;
    }
}

