/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.outline;

import org.eclipse.edt.compiler.core.ast.DefaultASTVisitor;
import org.eclipse.edt.compiler.core.ast.File;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.ImportDeclaration;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.ide.core.model.document.IEGLDocument;

public class ImportGroup {
    private IEGLDocument document;

    public ImportGroup(IEGLDocument document) {
        this.document = document;
    }

    public File getFile() {
        return this.document.getNewModelEGLFile();
    }

    public int getLength() {
        ImportGroupVisitor visitor = this.visitImports();
        int totalLength = visitor.totalLength;
        totalLength -= visitor.lengthOfNodeWithLargestOffset;
        return totalLength += visitor.nodeWithLargestOffset.getLength();
    }

    private ImportGroupVisitor visitImports() {
        File file = this.getFile();
        ImportGroupVisitor visitor = new ImportGroupVisitor();
        file.accept((IASTVisitor)visitor);
        return visitor;
    }

    public int getOffset() {
        ImportGroupVisitor visitor = this.visitImports();
        return visitor.smallestOffset;
    }

    private class ImportGroupVisitor
    extends DefaultASTVisitor {
        int totalLength = 0;
        int smallestOffset = 0;
        int largestOffset = -1;
        int lengthOfNodeWithLargestOffset = -1;
        Node nodeWithLargestOffset = null;

        private ImportGroupVisitor() {
        }

        public boolean visit(File file) {
            this.smallestOffset = file.getLength();
            return true;
        }

        public boolean visit(ImportDeclaration importDeclaration) {
            int offset = importDeclaration.getOffset();
            this.smallestOffset = Math.min(this.smallestOffset, offset);
            int currentLength = importDeclaration.getLength();
            this.totalLength += currentLength;
            if (offset > this.largestOffset) {
                this.largestOffset = offset;
                this.nodeWithLargestOffset = importDeclaration;
                this.lengthOfNodeWithLargestOffset = currentLength;
            }
            return false;
        }
    }
}

