/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.internal.quickfix;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.edt.ide.core.model.IEGLModelMarker;
import org.eclipse.edt.ide.ui.EDTUIPlugin;
import org.eclipse.edt.ide.ui.internal.dialogs.StatusInfo;

public final class ContributedProcessorDescriptor {
    private final IConfigurationElement fConfigurationElement;
    private Object fProcessorInstance;
    private final Set fHandledMarkerTypes;
    private static final String ID = "id";
    private static final String CLASS = "class";
    private static final String HANDLED_MARKER_TYPES = "handledMarkerTypes";
    private static final String MARKER_TYPE = "markerType";

    public ContributedProcessorDescriptor(IConfigurationElement element, boolean testMarkerTypes) {
        this.fConfigurationElement = element;
        this.fProcessorInstance = null;
        this.fHandledMarkerTypes = testMarkerTypes ? this.getHandledMarkerTypes(element) : null;
    }

    private Set getHandledMarkerTypes(IConfigurationElement element) {
        HashSet<String> map = new HashSet<String>(7);
        IConfigurationElement[] children = element.getChildren(HANDLED_MARKER_TYPES);
        int i = 0;
        while (i < children.length) {
            IConfigurationElement[] types = children[i].getChildren(MARKER_TYPE);
            int k = 0;
            while (k < types.length) {
                String attribute = types[k].getAttribute(ID);
                if (attribute != null) {
                    map.add(attribute);
                }
                ++k;
            }
            ++i;
        }
        if (map.isEmpty()) {
            map.add(IEGLModelMarker.BUILDPATH_PROBLEM_MARKER);
            map.add(IEGLModelMarker.TASK_MARKER);
            map.add("org.eclipse.ui.workbench.texteditor.error");
        }
        return map;
    }

    public IStatus checkSyntax() {
        IConfigurationElement[] children = this.fConfigurationElement.getChildren("enablement");
        if (children.length > 1) {
            String id = this.fConfigurationElement.getAttribute(ID);
            return new StatusInfo(4, "Only one < enablement > element allowed. Disabling " + id);
        }
        return new StatusInfo(0, "Syntactically correct quick assist/fix processor");
    }

    public Object getProcessor(Class expectedType) {
        block4: {
            if (this.fProcessorInstance == null) {
                try {
                    Object extension = this.fConfigurationElement.createExecutableExtension(CLASS);
                    if (expectedType.isInstance(extension)) {
                        this.fProcessorInstance = extension;
                        break block4;
                    }
                    String message = "Invalid extension to " + this.fConfigurationElement.getName() + ". Must extends '" + expectedType.getName() + "'." + this.fConfigurationElement.getContributor().getName();
                    EDTUIPlugin.log((IStatus)new Status(4, "org.eclipse.edt.ide.ui", message));
                    return null;
                }
                catch (CoreException e) {
                    EDTUIPlugin.log(e);
                    return null;
                }
            }
        }
        return this.fProcessorInstance;
    }

    public boolean canHandleMarkerType(String markerType) {
        return this.fHandledMarkerTypes == null || this.fHandledMarkerTypes.contains(markerType);
    }
}

