/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.edt.ide.ui.internal.deployment.Binding;
import org.eclipse.edt.ide.ui.internal.deployment.Bindings;
import org.eclipse.edt.ide.ui.internal.deployment.DeploymentFactory;
import org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot;
import org.eclipse.edt.ide.ui.internal.deployment.Parameters;
import org.eclipse.edt.ide.ui.internal.deployment.ui.EGLDDRootHelper;
import org.eclipse.edt.ide.ui.wizards.BindingEGLConfiguration;

public class BindingSQLDatabaseConfiguration
extends BindingEGLConfiguration {
    private boolean useUri;
    private String uri;
    private String dbVendorAndVersion = "";
    private String driverClass = "";
    private String connUrl = "";
    private String userName = "";
    private String password = "";
    private String dbName = "";
    private String connLocation;
    private String bindingName;
    private String defaultSchema;

    public BindingSQLDatabaseConfiguration() {
    }

    public BindingSQLDatabaseConfiguration(EGLDeploymentRoot root, IProject proj) {
        super(root, proj);
    }

    @Override
    protected void setDefaultAttributes() {
    }

    public String getDbms() {
        return this.dbVendorAndVersion;
    }

    public void setDbms(String dbms) {
        this.dbVendorAndVersion = dbms;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getConnUrl() {
        return this.connUrl;
    }

    public void setConnUrl(String connUrl) {
        this.connUrl = connUrl;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public boolean useUri() {
        return this.useUri;
    }

    public void setUseUri(boolean useUri) {
        this.useUri = useUri;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getConnLocation() {
        return this.connLocation;
    }

    public void setConnLocation(String connLocation) {
        this.connLocation = connLocation;
    }

    @Override
    public String getBindingName() {
        return this.bindingName;
    }

    @Override
    public void setBindingName(String bindingName) {
        this.bindingName = bindingName;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
    }

    public String getValidBindingName() {
        return this.getValidBindingName(this.getBindingName());
    }

    @Override
    public Object executeAddBinding(Bindings bindings) {
        Binding sqlBinding = DeploymentFactory.eINSTANCE.createBinding();
        bindings.getBinding().add((Object)sqlBinding);
        sqlBinding.setType(org.eclipse.edt.javart.resources.egldd.Binding.BINDING_DB_SQL);
        String bindingName = this.getValidBindingName(this.getBindingName());
        sqlBinding.setName(bindingName);
        Parameters params = null;
        if (this.getUri() == null || !this.getUri().startsWith("jndi://")) {
            params = DeploymentFactory.eINSTANCE.createParameters();
            sqlBinding.setParameters(params);
            EGLDDRootHelper.addOrUpdateParameter(params, "deployAsJndi", true);
            EGLDDRootHelper.addOrUpdateParameter(params, "jndiName", "jdbc/" + bindingName);
        }
        if (this.useUri()) {
            sqlBinding.setUseURI(true);
            sqlBinding.setUri(this.getUri());
        } else {
            if (params == null) {
                params = DeploymentFactory.eINSTANCE.createParameters();
                sqlBinding.setParameters(params);
            }
            sqlBinding.setUseURI(false);
            EGLDDRootHelper.addOrUpdateParameter(params, "dbms", this.getDbms());
            EGLDDRootHelper.addOrUpdateParameter(params, "sqlID", this.getUserName());
            EGLDDRootHelper.addOrUpdateParameter(params, "sqlPassword", this.getPassword());
            EGLDDRootHelper.addOrUpdateParameter(params, "jarList", this.getConnLocation());
            EGLDDRootHelper.addOrUpdateParameter(params, "sqlJDBCDriverClass", this.getDriverClass());
            EGLDDRootHelper.addOrUpdateParameter(params, "sqlDB", this.getConnUrl());
            EGLDDRootHelper.addOrUpdateParameter(params, "sqlSchema", this.getDefaultSchema());
        }
        return sqlBinding;
    }
}

