/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.ide.core.model.EGLCore;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.ui.editor.EGLCodeFormatterUtil;
import org.eclipse.edt.ide.ui.internal.EGLLogger;
import org.eclipse.edt.ide.ui.wizards.EGLContainerConfiguration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class MultiEGLFileOperation
extends WorkspaceModifyOperation {
    private EGLContainerConfiguration configuration;
    private Hashtable<String, String> sourceFileContents;
    protected IProject project;

    public MultiEGLFileOperation(EGLContainerConfiguration configuration, Hashtable<String, String> sourceFileContents) {
        this.configuration = configuration;
        this.sourceFileContents = sourceFileContents;
    }

    public String getFormattedFileContent(String fileContent) {
        String res = fileContent;
        try {
            Document doc = new Document();
            doc.set(fileContent);
            TextEdit edit = EGLCodeFormatterUtil.format((IDocument)doc, null);
            edit.apply((IDocument)doc);
            res = doc.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            EGLLogger.log((Object)this, e);
        }
        return res;
    }

    public void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Set<String> filePaths = this.sourceFileContents.keySet();
        monitor.beginTask("write EGL file: ", filePaths.size());
        for (String filePath : filePaths) {
            if (monitor.isCanceled()) break;
            monitor.subTask(filePath);
            this.writeFile(filePath, (IProgressMonitor)new NullProgressMonitor());
            monitor.worked(1);
        }
    }

    protected void writeFile(String filePath, IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        Path sourcePath;
        String fileName = MultiEGLFileOperation.getEGLFileName(filePath);
        String packageName = MultiEGLFileOperation.getPackageName(filePath);
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.configuration.getProjectName());
        IEGLProject eproject = EGLCore.create((IProject)this.project);
        IPackageFragmentRoot root = eproject.findPackageFragmentRoot((sourcePath = new Path(this.configuration.getContainerName())).makeAbsolute());
        IPackageFragment frag = root.getPackageFragment(packageName);
        IContainer container = (IContainer)frag.getResource();
        IFile file = container.getFile((IPath)new Path(String.valueOf(fileName) + ".egl"));
        if (file.exists()) {
            this.updateExistingFile(filePath, root, frag, file, monitor);
        } else {
            this.writeFileWithNewContent(filePath, root, frag, file, monitor);
        }
        this.updateEGLPathIfNeeded(monitor);
    }

    private IPackageFragment getFilePackFrag(String filePath) throws EGLModelException {
        String packageName = MultiEGLFileOperation.getPackageName(filePath);
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.configuration.getProjectName());
        IEGLProject eproject = EGLCore.create((IProject)this.project);
        Path sourcePath = new Path(this.configuration.getContainerName());
        IPackageFragmentRoot root = eproject.findPackageFragmentRoot(sourcePath.makeAbsolute());
        return root.getPackageFragment(packageName);
    }

    public IFile getFile(String filePath) throws EGLModelException {
        String fileName = MultiEGLFileOperation.getEGLFileName(filePath);
        IPackageFragment frag = this.getFilePackFrag(filePath);
        IContainer container = (IContainer)frag.getResource();
        return container.getFile((IPath)new Path(String.valueOf(fileName) + ".egl"));
    }

    public static String getPackageName(String fullQualifiedFileName) {
        int lastIndex;
        if (fullQualifiedFileName.startsWith(File.separator)) {
            fullQualifiedFileName = fullQualifiedFileName.substring(1);
        }
        if ((lastIndex = fullQualifiedFileName.lastIndexOf(File.separator)) < 0) {
            return "";
        }
        return fullQualifiedFileName.substring(0, lastIndex).replace(File.separator, ".");
    }

    public static String getEGLFileName(String fullQualifiedFileName) {
        if (fullQualifiedFileName.startsWith(File.separator)) {
            fullQualifiedFileName = fullQualifiedFileName.substring(1);
        }
        int startIndex = fullQualifiedFileName.lastIndexOf(File.separator);
        int lastIndex = fullQualifiedFileName.lastIndexOf(".egl");
        if (startIndex < 0) {
            return fullQualifiedFileName.substring(0, lastIndex);
        }
        return fullQualifiedFileName.substring(startIndex + 1, lastIndex);
    }

    protected void writeFileWithNewContent(String filePath, IPackageFragmentRoot root, IPackageFragment frag, IFile file, IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            this.createFile(root, frag, filePath);
        }
        catch (CoreException e) {
            EGLLogger.log((Object)this, e);
            throw e;
        }
        catch (InterruptedException e0) {
            EGLLogger.log((Object)this, e0);
        }
        try {
            String fileHeader = this.getFileHeader(MultiEGLFileOperation.getPackageName(filePath));
            String fileContents = this.sourceFileContents.get(filePath);
            String fileOutputString = this.getFormattedFileContent(String.valueOf(fileHeader) + fileContents);
            String encoding = null;
            if (file.exists()) {
                encoding = file.getCharset();
            } else {
                IContainer folder = (IContainer)frag.getResource();
                encoding = folder.getDefaultCharset();
            }
            ByteArrayInputStream stream = new ByteArrayInputStream(encoding == null ? fileOutputString.getBytes() : fileOutputString.getBytes(encoding));
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, monitor);
            } else {
                file.create((InputStream)stream, true, monitor);
            }
            ((InputStream)stream).close();
        }
        catch (IOException e1) {
            EGLLogger.log((Object)this, e1);
        }
    }

    private void updateExistingFile(String filePath, IPackageFragmentRoot root, IPackageFragment frag, IFile file, IProgressMonitor monitor) throws CoreException, InterruptedException {
        this.writeFileWithNewContent(filePath, root, frag, file, monitor);
    }

    protected String getFileHeader(String packName) {
        String fileContents = "";
        fileContents = packName.compareTo("") != 0 ? fileContents.concat("package " + packName + ";\n\n") : "";
        return fileContents;
    }

    private void createFile(IPackageFragmentRoot root, IPackageFragment pack, String filePath) throws CoreException, InterruptedException {
        Object createdWorkingCopy = null;
        try {
            if (pack == null) {
                pack = root.getPackageFragment("");
            }
            if (!pack.exists()) {
                String packName = pack.getElementName();
                pack = root.createPackageFragment(packName, true, null);
            }
            String fileOutputString = "";
            pack.createEGLFile(String.valueOf(MultiEGLFileOperation.getEGLFileName(filePath)) + ".egl", fileOutputString, true, (IProgressMonitor)new NullProgressMonitor());
        }
        finally {
            if (createdWorkingCopy != null) {
                createdWorkingCopy.destroy();
            }
        }
    }

    private void updateEGLPathIfNeeded(IProgressMonitor monitor) throws EGLModelException {
        String initialProjName;
        String currProjName;
        if (this.configuration.isNeed2UpdateEGLPath() && !(currProjName = this.configuration.getProjectName()).equals(initialProjName = this.configuration.getInitialProjectName()) && this.configuration.isUpdateEGLPath()) {
            IProject currProject = this.configuration.fWorkspaceRoot.getProject(currProjName);
            IEGLProject currEGLProj = EGLCore.create((IProject)currProject);
            IProject initialProj = this.configuration.fWorkspaceRoot.getProject(initialProjName);
            IEGLPathEntry newEntry = EGLCore.newProjectEntry((IPath)initialProj.getFullPath());
            if (!currEGLProj.isOnEGLPath((IResource)initialProj) && !currEGLProj.hasEGLPathCycle(new IEGLPathEntry[]{newEntry})) {
                IEGLPathEntry[] eglPathEntries = currEGLProj.getRawEGLPath();
                int oldLen = eglPathEntries.length;
                IEGLPathEntry[] newEGLPathEntries = new IEGLPathEntry[oldLen + 1];
                int i = 0;
                while (i < oldLen) {
                    newEGLPathEntries[i] = eglPathEntries[i];
                    ++i;
                }
                newEGLPathEntries[oldLen] = newEntry;
                currEGLProj.setRawEGLPath(newEGLPathEntries, monitor);
            }
        }
    }
}

