/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.jee;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.mof.EField;
import org.eclipse.edt.mof.EMember;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.EType;
import org.eclipse.edt.mof.MofFactory;
import org.eclipse.edt.mof.egl.Annotation;
import org.eclipse.edt.mof.egl.AnnotationType;

public class CommonUtilities {
    private static CommonUtilities instance = new CommonUtilities();
    private static Map<String, BaseAnnotationCreator> generationAnnotations = new HashMap<String, BaseAnnotationCreator>();

    static {
        CommonUtilities commonUtilities = instance;
        commonUtilities.getClass();
        XmlJavaTypeAdapter xmlJavaTypeAdapter = commonUtilities.new XmlJavaTypeAdapter("eglx.xml.javax.xml.bind.annotation.adapters", "XmlJavaTypeAdapter");
        generationAnnotations.put(xmlJavaTypeAdapter.getQualifiedName(), xmlJavaTypeAdapter);
    }

    public static Annotation getLocalAnnotation(Context ctx, String key) {
        if (generationAnnotations.containsKey(key)) {
            return org.eclipse.edt.gen.CommonUtilities.newInstance((EObject)generationAnnotations.get(key).getAnnotationType(ctx));
        }
        return null;
    }

    private abstract class BaseAnnotationCreator {
        private BaseAnnotationCreator() {
        }

        protected abstract AnnotationType getAnnotationType(Context var1);
    }

    private class XmlJavaTypeAdapter
    extends BaseAnnotationCreator {
        private String pkg;
        private String name;
        private AnnotationType annotationType;

        public XmlJavaTypeAdapter(String pkg, String name) {
            this.name = name;
            this.pkg = pkg;
        }

        public String getQualifiedName() {
            return String.valueOf(this.pkg) + '.' + this.name;
        }

        @Override
        protected AnnotationType getAnnotationType(Context ctx) {
            if (this.annotationType == null) {
                this.annotationType = ctx.getFactory().createAnnotationType();
                this.annotationType.setPackageName(this.pkg);
                this.annotationType.setName(this.name);
                EField eField = MofFactory.INSTANCE.createEField(true);
                eField.setName("value");
                eField.setEType((EType)MofFactory.INSTANCE.getEStringEDataType());
                eField.setContainment(true);
                this.annotationType.addMember((EMember)eField);
                eField = MofFactory.INSTANCE.createEField(true);
                eField.setName("type");
                eField.setEType((EType)MofFactory.INSTANCE.getEStringEDataType());
                eField.setContainment(true);
                this.annotationType.addMember((EMember)eField);
            }
            return this.annotationType;
        }
    }
}

