/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.debug.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.URISyntaxException;
import java.security.ProtectionDomain;
import org.eclipse.edt.debug.core.EDTDebugCoreMessages;
import org.eclipse.osgi.util.NLS;

public class SMAPTransformer
implements ClassFileTransformer {
    private File defaultLocation;

    public SMAPTransformer(String location) {
        if (location != null && location.length() != 0) {
            this.defaultLocation = new File(location);
        }
    }

    /*
     * Loose catch block
     */
    public byte[] transform(ClassLoader loader, String className, Class redefiningClass, ProtectionDomain domain, byte[] classBytes) throws IllegalClassFormatException {
        byte[] byArray;
        FileInputStream inputStream;
        block15: {
            File inSmapFile;
            File location;
            inputStream = null;
            try {
                location = new File(domain.getCodeSource().getLocation().toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                location = new File(domain.getCodeSource().getLocation().getFile().replaceAll("%20", " "));
            }
            try {
                inSmapFile = new File(location, String.valueOf(className) + '.' + "eglsmap");
                inputStream = new FileInputStream(inSmapFile);
            }
            catch (Exception exception) {
                inSmapFile = new File(this.defaultLocation, String.valueOf(className) + '.' + "eglsmap");
                inputStream = new FileInputStream(inSmapFile);
            }
            int length = (int)inSmapFile.length();
            byte[] smapBytes = new byte[length];
            inputStream.read(smapBytes, 0, length);
            byArray = new TransformerWorker().transform(className, classBytes, smapBytes);
            if (inputStream == null) break block15;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
        catch (IOException iOException) {
            block16: {
                try {
                    if (inputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException3) {}
            }
            return null;
        }
    }

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File dir = new File(path);
            if (dir.exists() && dir.isDirectory()) {
                SMAPTransformer.processDirectory(dir);
            }
            ++n2;
        }
    }

    static void processDirectory(File dir) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] classBytes;
            byte[] smapBytes;
            File classFile;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                SMAPTransformer.processDirectory(file);
            } else if (file.getName().endsWith("eglsmap") && (classFile = new File(dir, String.valueOf(file.getName().substring(0, file.getName().length() - "eglsmap".length())) + "class")).exists() && (smapBytes = SMAPTransformer.getBytes(file)) != null && (classBytes = SMAPTransformer.getBytes(classFile)) != null) {
                try {
                    byte[] newBytes = new TransformerWorker().transform(file.getAbsolutePath(), classBytes, smapBytes);
                    if (newBytes != null) {
                        SMAPTransformer.writeBytes(classFile, newBytes);
                    }
                }
                catch (IllegalClassFormatException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static byte[] getBytes(File file) {
        BufferedInputStream is = null;
        is = new BufferedInputStream(new FileInputStream(file));
        byte[] b = new byte[is.available()];
        is.read(b);
        byte[] byArray = b;
        if (is == null) return byArray;
        try {
            is.close();
            return byArray;
        }
        catch (Exception exception) {}
        return byArray;
        catch (Exception e) {
            try {
                e.printStackTrace();
                if (is == null) return null;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                is.close();
                return null;
            }
            catch (Exception exception) {}
            return null;
        }
    }

    static void writeBytes(File file, byte[] contents) {
        block14: {
            OutputStream os = null;
            try {
                try {
                    os = new BufferedOutputStream(new FileOutputStream(file));
                    os.write(contents);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static class TransformerWorker {
        private String className;
        private int sourceDebugExtensionIndex;
        private byte[] debugInfoBytes;
        private byte[] inClassBytes;
        private int inClassOffset;
        private byte[] outClassBytes;
        private int outClassIndex;

        public byte[] transform(String name, byte[] classBytes, byte[] smapBytes) throws IllegalClassFormatException {
            this.className = name;
            this.inClassBytes = classBytes;
            this.debugInfoBytes = smapBytes;
            this.outClassBytes = new byte[classBytes.length + this.debugInfoBytes.length + 100];
            if (this.updateClass()) {
                if (this.outClassIndex < this.outClassBytes.length) {
                    byte[] temp = new byte[this.outClassIndex];
                    System.arraycopy(this.outClassBytes, 0, temp, 0, this.outClassIndex);
                    return temp;
                }
                return this.outClassBytes;
            }
            return null;
        }

        private boolean updateClass() {
            this.copyBytes(8);
            int tagPosition = this.outClassIndex;
            int tagCount = this.readUnicode2();
            this.writeU2(tagCount);
            if (!this.copyTags(tagCount)) {
                return false;
            }
            if (this.sourceDebugExtensionIndex < 0) {
                this.writeUtf8ForSourceDebugExtension();
                this.sourceDebugExtensionIndex = tagCount++;
                this.randomAccessWriteU2(tagPosition, tagCount);
            }
            this.copyBytes(6);
            int interfaceCount = this.readUnicode2();
            this.writeU2(interfaceCount);
            this.copyBytes(interfaceCount * 2);
            this.copyMembers();
            this.copyMembers();
            int attrPosition = this.outClassIndex;
            int attrCount = this.readUnicode2();
            this.writeU2(attrCount);
            if (!this.copyAttrs(attrCount)) {
                this.randomAccessWriteU2(attrPosition, ++attrCount);
            }
            this.writeAttrForSourceDebugExtension(this.debugInfoBytes);
            return true;
        }

        private void copyMembers() {
            int count = this.readUnicode2();
            this.writeU2(count);
            int i = 0;
            while (i < count) {
                this.copyBytes(6);
                int attrCount = this.readUnicode2();
                this.writeU2(attrCount);
                this.copyAttrs(attrCount);
                ++i;
            }
        }

        private boolean copyAttrs(int attrCount) {
            boolean sourceDebugExtensionFound = false;
            int i = 0;
            while (i < attrCount) {
                int nameIndex = this.readUnicode2();
                if (nameIndex == this.sourceDebugExtensionIndex) {
                    sourceDebugExtensionFound = true;
                } else {
                    this.writeU2(nameIndex);
                    int length = this.readUnicode4();
                    this.writeU4(length);
                    this.copyBytes(length);
                }
                ++i;
            }
            return sourceDebugExtensionFound;
        }

        private void writeAttrForSourceDebugExtension(byte[] debugInfo) {
            this.writeU2(this.sourceDebugExtensionIndex);
            this.writeU4(debugInfo.length);
            int i = 0;
            while (i < debugInfo.length) {
                this.writeU1(debugInfo[i]);
                ++i;
            }
        }

        private void randomAccessWriteU2(int pos, int val) {
            int savePos = this.outClassIndex;
            this.outClassIndex = pos;
            this.writeU2(val);
            this.outClassIndex = savePos;
        }

        private int readUnicode1() {
            return this.inClassBytes[this.inClassOffset++] & 0xFF;
        }

        private int readUnicode2() {
            return (this.readUnicode1() << 8) + this.readUnicode1();
        }

        private int readUnicode4() {
            return (this.readUnicode2() << 16) + this.readUnicode2();
        }

        private void writeU1(int val) {
            this.outClassBytes[this.outClassIndex++] = (byte)val;
        }

        private void writeU2(int val) {
            this.writeU1(val >> 8);
            this.writeU1(val & 0xFF);
        }

        private void writeU4(int val) {
            this.writeU2(val >> 16);
            this.writeU2(val & 0xFFFF);
        }

        private void copyBytes(int count) {
            int i = 0;
            while (i < count) {
                this.outClassBytes[this.outClassIndex++] = this.inClassBytes[this.inClassOffset++];
                ++i;
            }
        }

        private byte[] readBytes(int count) {
            byte[] bytes = new byte[count];
            int i = 0;
            while (i < count) {
                bytes[i] = this.inClassBytes[this.inClassOffset++];
                ++i;
            }
            return bytes;
        }

        private void writeBytes(byte[] bytes) {
            int i = 0;
            while (i < bytes.length) {
                this.outClassBytes[this.outClassIndex++] = bytes[i];
                ++i;
            }
        }

        private boolean copyTags(int tagCount) {
            this.sourceDebugExtensionIndex = -1;
            int i = 1;
            while (i < tagCount) {
                int tag = this.readUnicode1();
                this.writeU1(tag);
                switch (tag) {
                    case 1: {
                        int length = this.readUnicode2();
                        this.writeU2(length);
                        byte[] utf8 = this.readBytes(length);
                        String str = null;
                        try {
                            str = new String(utf8, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            System.out.println(NLS.bind((String)EDTDebugCoreMessages.TransformerUnsupportedEncoding, (Object)this.className));
                            return false;
                        }
                        if (str.equals("SourceDebugExtension")) {
                            this.sourceDebugExtensionIndex = i;
                        }
                        this.writeBytes(utf8);
                        break;
                    }
                    case 3: {
                        this.copyBytes(4);
                        break;
                    }
                    case 4: {
                        this.copyBytes(4);
                        break;
                    }
                    case 5: {
                        this.copyBytes(8);
                        ++i;
                        break;
                    }
                    case 6: {
                        this.copyBytes(8);
                        ++i;
                        break;
                    }
                    case 7: {
                        this.copyBytes(2);
                        break;
                    }
                    case 8: {
                        this.copyBytes(2);
                        break;
                    }
                    case 9: {
                        this.copyBytes(4);
                        break;
                    }
                    case 10: {
                        this.copyBytes(4);
                        break;
                    }
                    case 11: {
                        this.copyBytes(4);
                        break;
                    }
                    case 12: {
                        this.copyBytes(4);
                        break;
                    }
                    default: {
                        System.out.println(NLS.bind((String)EDTDebugCoreMessages.TransformerUnknownTag, (Object)this.className));
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        private void writeUtf8ForSourceDebugExtension() {
            this.writeU1(1);
            this.writeU2("SourceDebugExtension".length());
            int i = 0;
            while (i < "SourceDebugExtension".length()) {
                this.writeU1("SourceDebugExtension".charAt(i));
                ++i;
            }
        }
    }
}

