/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.gen.java.templates.eglx.lang;

import org.eclipse.edt.gen.GenerationException;
import org.eclipse.edt.gen.java.CommonUtilities;
import org.eclipse.edt.gen.java.Context;
import org.eclipse.edt.gen.java.templates.JavaTemplate;
import org.eclipse.edt.mof.EObject;
import org.eclipse.edt.mof.codegen.api.TabbedWriter;
import org.eclipse.edt.mof.codegen.api.TemplateContext;
import org.eclipse.edt.mof.egl.BinaryExpression;
import org.eclipse.edt.mof.egl.Expression;
import org.eclipse.edt.mof.egl.InvocationExpression;
import org.eclipse.edt.mof.egl.Type;

public class StringTypeTemplate
extends JavaTemplate {
    public void genDefaultValue(Type type, Context ctx, TabbedWriter out) {
        out.print("\"\"");
    }

    public void genBinaryExpression(Type type, Context ctx, TabbedWriter out, BinaryExpression arg) throws GenerationException {
        if (arg.getLHS().isNullable() || arg.getRHS().isNullable() || this.getNativeStringOperation(arg).length() == 0) {
            out.print(String.valueOf(ctx.getNativeImplementationMapping((Type)arg.getOperation().getContainer())) + '.');
            out.print(CommonUtilities.getNativeRuntimeOperationName((BinaryExpression)arg));
            out.print("(");
            ctx.invoke("genExpression", (EObject)arg.getLHS(), new Object[]{ctx, out, arg.getOperation().getParameters().get(0)});
            out.print(", ");
            ctx.invoke("genExpression", (EObject)arg.getRHS(), new Object[]{ctx, out, arg.getOperation().getParameters().get(1)});
            out.print(")" + CommonUtilities.getNativeRuntimeComparisionOperation((BinaryExpression)arg));
        } else {
            out.print(this.getNativeStringPrefixOperation(arg));
            out.print("(");
            ctx.invoke("genExpression", arg.getLHS(), (TemplateContext)ctx, out);
            out.print(")");
            out.print(this.getNativeStringOperation(arg));
            ctx.invoke("genExpression", arg.getRHS(), (TemplateContext)ctx, out);
            out.print(this.getNativeStringComparisionOperation(arg));
        }
    }

    public void genContainerBasedInvocation(Type type, Context ctx, TabbedWriter out, InvocationExpression expr) {
        ctx.invoke("genRuntimeTypeName", type, new Object[]{ctx, out, JavaTemplate.TypeNameKind.EGLImplementation});
        out.print(".");
        ctx.invoke("genName", (EObject)expr.getTarget(), new Object[]{ctx, out});
        out.print("(");
        ctx.invoke("genInvocationNonstaticArgument", (Expression)expr, (TemplateContext)ctx, out);
        ctx.invoke("genInvocationArguments", (Expression)expr, (TemplateContext)ctx, out);
        out.print(")");
    }

    protected String getNativeStringPrefixOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("!=")) {
            return "!";
        }
        return "";
    }

    protected String getNativeStringOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("+")) {
            return " + ";
        }
        if (op.equals("==")) {
            return ".equals(";
        }
        if (op.equals("!=")) {
            return ".equals(";
        }
        if (op.equals("<")) {
            return ".compareTo(";
        }
        if (op.equals(">")) {
            return ".compareTo(";
        }
        if (op.equals("<=")) {
            return ".compareTo(";
        }
        if (op.equals(">=")) {
            return ".compareTo(";
        }
        if (op.equals("&&")) {
            return " && ";
        }
        if (op.equals("||")) {
            return " || ";
        }
        if (op.equals("::")) {
            return " + ";
        }
        return "";
    }

    protected String getNativeStringComparisionOperation(BinaryExpression expr) {
        String op = expr.getOperator();
        if (op.equals("==")) {
            return ")";
        }
        if (op.equals("!=")) {
            return ")";
        }
        if (op.equals("<")) {
            return ") < 0";
        }
        if (op.equals(">")) {
            return ") > 0";
        }
        if (op.equals("<=")) {
            return ") <= 0";
        }
        if (op.equals(">=")) {
            return ") >= 0";
        }
        return "";
    }
}

