/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.AbstractRecoverer;
import org.eclipse.edt.ide.core.internal.errors.ErrorMarkerCollector;
import org.eclipse.edt.ide.core.internal.errors.ErrorNonTerminalNode;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.Reporter;
import org.eclipse.edt.ide.core.internal.errors.TerminalNode;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.core.internal.model.document.EGLNodeNameUtility;

public class MissingNonTerminalRecoverer
extends AbstractRecoverer {
    int bestCandidate;
    int bestDistance;

    @Override
    public int recoverDistance(ParseStack stack, TokenStream tokenStream) {
        this.bestCandidate = -1;
        this.bestDistance = -1;
        short[] nonTerminalCandidates = this.grammar.getNonTerminalCandidates(stack.getCurrentState());
        int i = 0;
        while (i < nonTerminalCandidates.length) {
            int curDistance = this.recoveryDistance(nonTerminalCandidates[i], stack, tokenStream);
            if (curDistance > this.bestDistance) {
                this.bestCandidate = nonTerminalCandidates[i];
                this.bestDistance = curDistance;
            }
            ++i;
        }
        return this.bestDistance;
    }

    private int recoveryDistance(int candidate, ParseStack stack, TokenStream tokenStream) {
        stack = stack.copy();
        tokenStream = tokenStream.copy();
        stack.shift(new ErrorNonTerminalNode(candidate));
        int distance = this.tryParseAhead(stack, tokenStream);
        Reporter.getInstance().missingNonTerminalDistance(candidate, distance);
        return distance;
    }

    @Override
    public void recover(ParseStack stack, TokenStream tokenStream) {
        Reporter.getInstance().recoverMissingNonTerminal(this.bestCandidate);
        stack.shift(new ErrorNonTerminalNode(this.bestCandidate));
        this.errorMessage(stack, tokenStream, tokenStream.lookAhead());
    }

    @Override
    public void errorMessage(ParseStack stack, TokenStream tokenStream, TerminalNode errorTerminal) {
        String message = "\tMissing " + EGLNodeNameUtility.getNonterminalName(this.bestCandidate);
        ErrorMarkerCollector.instance.add(errorTerminal.offset, errorTerminal.offset + errorTerminal.text.length(), errorTerminal.line, message);
    }
}

