/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.errors;

import org.eclipse.edt.ide.core.internal.errors.AbstractRecoverer;
import org.eclipse.edt.ide.core.internal.errors.InvalidPhraseRecoverer;
import org.eclipse.edt.ide.core.internal.errors.InvalidTerminalRecoverer;
import org.eclipse.edt.ide.core.internal.errors.MissingNonTerminalRecoverer;
import org.eclipse.edt.ide.core.internal.errors.MissingTerminalRecoverer;
import org.eclipse.edt.ide.core.internal.errors.ParseStack;
import org.eclipse.edt.ide.core.internal.errors.TokenStream;
import org.eclipse.edt.ide.core.internal.errors.UnexpectedTerminalRecoverer;

public class SyntaxErrorRecoverer {
    private ParseStack stack;
    private TokenStream tokenStream;
    private AbstractRecoverer[] recoverers = new AbstractRecoverer[]{new UnexpectedTerminalRecoverer(), new MissingTerminalRecoverer(), new InvalidTerminalRecoverer(), new MissingNonTerminalRecoverer(), new InvalidPhraseRecoverer()};

    public SyntaxErrorRecoverer(ParseStack stack, TokenStream tokenStream) {
        this.stack = stack;
        this.tokenStream = tokenStream;
    }

    public AbstractRecoverer recover() {
        int bestRecovery = this.selectRecovery();
        this.recoverers[bestRecovery].recover(this.stack, this.tokenStream);
        return this.recoverers[bestRecovery];
    }

    private int selectRecovery() {
        int i = 0;
        while (i < this.recoverers.length) {
            if (this.recoverers[i].recoverDistance(this.stack, this.tokenStream) >= 3) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

