/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.edt.compiler.internal.core.builder.BuildException;
import org.eclipse.edt.compiler.internal.core.builder.CancelledException;
import org.eclipse.edt.compiler.internal.core.builder.IBuildNotifier;
import org.eclipse.edt.compiler.internal.core.builder.NullBuildNotifier;
import org.eclipse.edt.ide.core.CoreIDEPluginStrings;
import org.eclipse.edt.ide.core.EDTCoreIDEPlugin;
import org.eclipse.edt.ide.core.internal.builder.AbstractMarkerProblemRequestor;
import org.eclipse.edt.ide.core.internal.builder.BuildManager;
import org.eclipse.edt.ide.core.internal.builder.BuildNotifier;
import org.eclipse.edt.ide.core.internal.generation.CleanGenerator;
import org.eclipse.edt.ide.core.internal.generation.GenerationBuildManager;
import org.eclipse.edt.ide.core.internal.generation.IncrementalGenerator;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.utils.ProjectSettingsUtility;

public class GenerationBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        Object notifier = monitor == null ? NullBuildNotifier.getInstance() : new BuildNotifier(monitor);
        boolean isOK = false;
        IResourceDelta delta = this.getDelta(this.getProject());
        notifier.begin();
        try {
            try {
                if (this.isWorthBuilding()) {
                    if (kind == 6) {
                        this.doClean();
                        this.cleanBuild(delta, (IBuildNotifier)notifier);
                    } else if (!GenerationBuildManager.getInstance().getProjectState(this.getProject())) {
                        this.doClean();
                        this.cleanBuild(null, (IBuildNotifier)notifier);
                    } else if (this.needFullBuild()) {
                        this.doClean();
                        this.cleanBuild(null, (IBuildNotifier)notifier);
                    } else if (delta == null) {
                        this.doClean();
                        this.cleanBuild(delta, (IBuildNotifier)notifier);
                    } else {
                        this.incrementalBuild(delta, (IBuildNotifier)notifier);
                    }
                    isOK = true;
                }
            }
            catch (CancelledException cancelledException) {
                throw new OperationCanceledException();
            }
        }
        catch (Throwable throwable) {
            if (!isOK) {
                GenerationBuildManager.getInstance().setProjectState(this.getProject(), false);
            } else {
                GenerationBuildManager.getInstance().putProject(this.getProject(), (String[])(ProjectSettingsUtility.getCompilerId(this.getProject()) == null ? ProjectSettingsUtility.getWorkspaceGeneratorIds() : null));
            }
            notifier.done();
            throw throwable;
        }
        if (!isOK) {
            GenerationBuildManager.getInstance().setProjectState(this.getProject(), false);
        } else {
            GenerationBuildManager.getInstance().putProject(this.getProject(), (String[])(ProjectSettingsUtility.getCompilerId(this.getProject()) == null ? ProjectSettingsUtility.getWorkspaceGeneratorIds() : null));
        }
        notifier.done();
        return null;
    }

    protected void clean(IProgressMonitor monitor) {
        try {
            this.doClean();
        }
        catch (Exception e) {
            EDTCoreIDEPlugin.getPlugin().log("EDT Generation Clean Failure", e);
            GenerationBuildManager.getInstance().clear(this.getProject());
        }
    }

    protected boolean cleanBuild(IResourceDelta delta, IBuildNotifier notifier) {
        GenerationBuildManager.getInstance().setProjectState(this.getProject(), false);
        CleanGenerator gen = new CleanGenerator(this, notifier);
        return gen.build(delta);
    }

    protected boolean incrementalBuild(IResourceDelta delta, IBuildNotifier notifier) {
        GenerationBuildManager.getInstance().setProjectState(this.getProject(), false);
        IncrementalGenerator gen = new IncrementalGenerator(this, notifier);
        return gen.build(delta);
    }

    protected void doClean() {
        GenerationBuildManager.getInstance().clear(this.getProject());
        this.deleteAllMarkers();
    }

    protected void deleteAllMarkers() {
        try {
            this.getProject().deleteMarkers(EDTCoreIDEPlugin.GENERATION_PROBLEM, true, 2);
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean needFullBuild() {
        if (ProjectSettingsUtility.getCompilerId(this.getProject()) == null) {
            String[] oldIds = GenerationBuildManager.getInstance().getDefaultGenIDs(this.getProject());
            if (oldIds == null) {
                return true;
            }
            String[] currIds = ProjectSettingsUtility.getWorkspaceGeneratorIds();
            if (currIds.length != oldIds.length) {
                return true;
            }
            String[] stringArray = currIds;
            int n = currIds.length;
            int n2 = 0;
            while (n2 < n) {
                String curr = stringArray[n2];
                boolean foundMatch = false;
                String[] stringArray2 = oldIds;
                int n3 = oldIds.length;
                int n4 = 0;
                while (n4 < n3) {
                    String old = stringArray2[n4];
                    if (curr.equals(old)) {
                        foundMatch = true;
                        break;
                    }
                    ++n4;
                }
                if (!foundMatch) {
                    return true;
                }
                ++n2;
            }
        } else if (GenerationBuildManager.getInstance().getDefaultGenIDs(this.getProject()) != null) {
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isWorthBuilding() {
        try {
            if (this.projectHasUnhandledBuildException(this.getProject())) {
                this.getProject().deleteMarkers(EDTCoreIDEPlugin.GENERATION_PROBLEM, true, 2);
                IMarker marker = this.getProject().createMarker(EDTCoreIDEPlugin.GENERATION_PROBLEM);
                marker.setAttribute("message", (Object)CoreIDEPluginStrings.projectHasBuildProblem);
                marker.setAttribute("severity", 2);
                return false;
            }
            IProject currentProject = this.getProject();
            IProject[] requiredProjects = ProjectBuildPathManager.getInstance().getProjectBuildPath(this.getProject()).getRequiredProjects();
            int i = 0;
            while (true) {
                if (i >= requiredProjects.length) {
                    return true;
                }
                IProject p = requiredProjects[i];
                if (p.exists() && p.isOpen() && !BuildManager.getInstance().getProjectState(p)) {
                    currentProject.deleteMarkers(EDTCoreIDEPlugin.GENERATION_PROBLEM, true, 2);
                    IMarker marker = currentProject.createMarker(EDTCoreIDEPlugin.GENERATION_PROBLEM);
                    marker.setAttribute("message", (Object)(this.projectHasUnhandledBuildException(p) ? CoreIDEPluginStrings.bind((String)CoreIDEPluginStrings.prereqProjectHasBuildProblem, (Object)p.getName()) : CoreIDEPluginStrings.bind((String)CoreIDEPluginStrings.prereqProjectMustBeRebuilt, (Object)p.getName())));
                    marker.setAttribute("severity", 2);
                    return false;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private boolean projectHasUnhandledBuildException(IProject project) throws CoreException {
        IMarker[] markers = project.findMarkers(AbstractMarkerProblemRequestor.BUILD_PROBLEM, false, 0);
        return markers.length > 0;
    }
}

