/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.generation;

import org.eclipse.edt.compiler.internal.util.EGLMessage;
import org.eclipse.edt.compiler.internal.util.IGenerationResultsMessage;
import org.eclipse.edt.ide.core.generation.IGenerationResult;
import org.eclipse.edt.ide.core.internal.generation.GenerationResultsMessage;
import org.eclipse.edt.ide.core.internal.generation.PartWrapper;

public class GenerationResult
implements IGenerationResult {
    private PartWrapper part = null;
    private IGenerationResultsMessage[] messages = null;
    private int type;
    private boolean hasErrors = false;
    private boolean hasWarnings = false;

    public GenerationResult(PartWrapper part, EGLMessage[] messages, int type) {
        this(messages, type);
        this.part = part;
    }

    protected GenerationResult(EGLMessage[] messages, int type) {
        this.messages = this.convertMessages(messages);
        this.type = type;
        this.initalizeHasErrors();
        this.initializeHasWarnings();
    }

    private IGenerationResultsMessage[] convertMessages(EGLMessage[] eglMsgs) {
        if (eglMsgs == null) {
            return null;
        }
        IGenerationResultsMessage[] genMessages = new IGenerationResultsMessage[eglMsgs.length];
        int i = 0;
        while (i < genMessages.length) {
            genMessages[i] = this.convertMessage(eglMsgs[i]);
            ++i;
        }
        return genMessages;
    }

    private IGenerationResultsMessage convertMessage(EGLMessage eglMsg) {
        if (eglMsg == null) {
            return null;
        }
        return new GenerationResultsMessage(eglMsg);
    }

    @Override
    public PartWrapper getPart() {
        return this.part;
    }

    @Override
    public IGenerationResultsMessage[] getMessages() {
        return this.messages;
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }

    private void initalizeHasErrors() {
        this.hasErrors = false;
        IGenerationResultsMessage[] msgs = this.getMessages();
        int i = 0;
        while (i < msgs.length) {
            if (this.messages[i].isError()) {
                this.hasErrors = true;
                break;
            }
            ++i;
        }
    }

    @Override
    public boolean hasWarnings() {
        return this.hasWarnings;
    }

    private void initializeHasWarnings() {
        this.hasWarnings = false;
        IGenerationResultsMessage[] msgs = this.getMessages();
        int i = 0;
        while (i < msgs.length) {
            if (this.messages[i].getSeverity() == 2) {
                this.hasWarnings = true;
                break;
            }
            ++i;
        }
    }

    @Override
    public int getType() {
        return this.type;
    }
}

