/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.edt.ide.core.internal.builder.IFileSystemObjectStore;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPath;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathEntry;
import org.eclipse.edt.ide.core.internal.lookup.ProjectBuildPathManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectEnvironmentManager;
import org.eclipse.edt.ide.core.internal.lookup.ProjectIREnvironment;
import org.eclipse.edt.ide.core.internal.lookup.ProjectInfoManager;
import org.eclipse.edt.mof.serialization.IEnvironment;
import org.eclipse.edt.mof.serialization.ObjectStore;

public class ProjectBuildPathEntryManager {
    private static final ProjectBuildPathEntryManager INSTANCE = new ProjectBuildPathEntryManager();
    private Map<IProject, ProjectBuildPathEntry> projectBuildPathEntries;

    private ProjectBuildPathEntryManager() {
        this.init();
    }

    private void init() {
        this.projectBuildPathEntries = new HashMap<IProject, ProjectBuildPathEntry>();
    }

    public static ProjectBuildPathEntryManager getInstance() {
        return INSTANCE;
    }

    public ProjectBuildPathEntry getProjectBuildPathEntry(IProject project) {
        ProjectBuildPathEntry result = this.projectBuildPathEntries.get(project);
        if (result == null) {
            result = new ProjectBuildPathEntry(ProjectInfoManager.getInstance().getProjectInfo(project));
            this.projectBuildPathEntries.put(project, result);
            ProjectBuildPath buildPath = ProjectBuildPathManager.getInstance().getProjectBuildPath(project);
            IPath path = buildPath.getOutputLocation().getFullPath();
            ProjectIREnvironment irEnv = ProjectEnvironmentManager.getInstance().getIREnvironment(project);
            result.setObjectStores(new ObjectStore[]{new IFileSystemObjectStore(path, (IEnvironment)irEnv, "XML"), new IFileSystemObjectStore(path, (IEnvironment)irEnv, "XML", ".eglxml")});
            result.setDeclaringEnvironment(ProjectEnvironmentManager.getInstance().getProjectEnvironment(project));
        }
        return result;
    }

    public void remove(IProject project) {
        this.projectBuildPathEntries.remove(project);
    }

    public void clear(IProject project, boolean clean) {
        ProjectBuildPathEntry result = this.projectBuildPathEntries.get(project);
        if (result != null) {
            result.clear(clean);
        }
    }

    public int getCount() {
        return this.projectBuildPathEntries.size();
    }
}

