/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.lookup.workingcopy;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.edt.ide.core.internal.lookup.workingcopy.WorkingCopyProjectInfo;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IWorkingCopy;

public class WorkingCopyProjectInfoManager {
    private static WorkingCopyProjectInfoManager INSTANCE = new WorkingCopyProjectInfoManager();
    private HashMap wcProjectInfoMap = new HashMap(5);

    public static WorkingCopyProjectInfoManager getInstance() {
        return INSTANCE;
    }

    private WorkingCopyProjectInfoManager() {
    }

    public WorkingCopyProjectInfo getProjectInfo(IProject project) {
        WorkingCopyProjectInfo prjInfo = (WorkingCopyProjectInfo)this.wcProjectInfoMap.get(project);
        if (prjInfo == null) {
            prjInfo = new WorkingCopyProjectInfo(project);
            this.wcProjectInfoMap.put(project, prjInfo);
        }
        return prjInfo;
    }

    public WorkingCopyProjectInfo getProjectInfo(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return this.getProjectInfo(project);
    }

    public void resetWorkingCopies() {
        for (WorkingCopyProjectInfo prjInfo : this.wcProjectInfoMap.values()) {
            prjInfo.resetWorkingCopies();
        }
    }

    public void clear(IProject project) {
        WorkingCopyProjectInfo prjInfo = (WorkingCopyProjectInfo)this.wcProjectInfoMap.get(project);
        if (prjInfo != null) {
            prjInfo.clear();
        }
    }

    protected boolean fileBeingEdited(IWorkingCopy[] workingCopies, IFile file) {
        int i = 0;
        while (i < workingCopies.length) {
            IWorkingCopy copy = workingCopies[i];
            IEGLFile eglFile = (IEGLFile)copy.getOriginalElement();
            IFile workingFile = (IFile)eglFile.getResource();
            if (workingFile.equals((Object)file)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void remove(IProject project) {
        this.wcProjectInfoMap.remove(project);
    }

    public int getCount() {
        return this.wcProjectInfoMap.size();
    }
}

