/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.edt.compiler.internal.core.utils.CharOperation;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLElementDelta;
import org.eclipse.edt.ide.core.internal.model.EGLElementInfo;
import org.eclipse.edt.ide.core.internal.model.EGLModel;
import org.eclipse.edt.ide.core.internal.model.EGLModelManager;
import org.eclipse.edt.ide.core.internal.model.MemberElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceFieldElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourceFunctionElementInfo;
import org.eclipse.edt.ide.core.internal.model.SourcePartElementInfo;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IParent;

public class EGLElementDeltaBuilder {
    IEGLElement eglElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    EGLElementDelta delta;
    ArrayList added;
    ArrayList removed;

    public EGLElementDeltaBuilder(IEGLElement eglElement) {
        this.eglElement = eglElement;
        this.initialize();
        this.recordElementInfo(eglElement, (EGLModel)this.eglElement.getEGLModel(), 0);
    }

    public EGLElementDeltaBuilder(IEGLElement eglElement, int maxDepth) {
        this.eglElement = eglElement;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordElementInfo(eglElement, (EGLModel)this.eglElement.getEGLModel(), 0);
    }

    private void added(IEGLElement element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    public void buildDeltas() {
        this.recordNewPositions(this.eglElement, 0);
        this.findAdditions(this.eglElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.eglElement, 0);
        this.trimDelta(this.delta);
        if (this.delta.getAffectedChildren().length == 0) {
            this.delta.contentChanged();
        }
    }

    private void findAdditions(IEGLElement newElement, int depth) {
        IEGLElement[] children;
        EGLElementInfo oldInfo = this.getElementInfo(newElement);
        if (oldInfo == null && depth < this.maxDepth) {
            this.delta.added(newElement);
            this.added(newElement);
        } else {
            this.removeElementInfo(newElement);
        }
        if (depth >= this.maxDepth) {
            this.delta.changed(newElement, 1);
            return;
        }
        EGLElementInfo newInfo = null;
        try {
            newInfo = (EGLElementInfo)((EGLElement)newElement).getElementInfo();
        }
        catch (EGLModelException eGLModelException) {
            return;
        }
        this.findContentChange(oldInfo, newInfo, newElement);
        if (oldInfo != null && newElement instanceof IParent && (children = newInfo.getChildren()) != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                this.findAdditions(children[i], depth + 1);
                ++i;
            }
        }
    }

    private void findChangesInPositioning(IEGLElement element, int depth) {
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.delta.changed(element, 256);
        }
        if (element instanceof IParent) {
            EGLElementInfo info = null;
            try {
                info = (EGLElementInfo)((EGLElement)element).getElementInfo();
            }
            catch (EGLModelException eGLModelException) {
                return;
            }
            IEGLElement[] children = info.getChildren();
            if (children != null) {
                int length = children.length;
                int i = 0;
                while (i < length) {
                    this.findChangesInPositioning(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void findContentChange(EGLElementInfo oldInfo, EGLElementInfo newInfo, IEGLElement newElement) {
        if (oldInfo instanceof MemberElementInfo && newInfo instanceof MemberElementInfo) {
            if (((MemberElementInfo)oldInfo).getModifiers() != ((MemberElementInfo)newInfo).getModifiers()) {
                this.delta.changed(newElement, 2);
            } else if (oldInfo instanceof SourceFunctionElementInfo && newInfo instanceof SourceFunctionElementInfo) {
                if (!CharOperation.equals((char[])((SourceFunctionElementInfo)oldInfo).getReturnTypeName(), (char[])((SourceFunctionElementInfo)newInfo).getReturnTypeName())) {
                    this.delta.changed(newElement, 1);
                }
            } else if (oldInfo instanceof SourceFieldElementInfo && newInfo instanceof SourceFieldElementInfo && !CharOperation.equals((char[])((SourceFieldElementInfo)oldInfo).getTypeName(), (char[])((SourceFieldElementInfo)newInfo).getTypeName())) {
                this.delta.changed(newElement, 1);
            }
        }
        if (oldInfo instanceof SourcePartElementInfo && newInfo instanceof SourcePartElementInfo) {
            SourcePartElementInfo oldSourcePartInfo = (SourcePartElementInfo)oldInfo;
            SourcePartElementInfo newSourcePartInfo = (SourcePartElementInfo)newInfo;
            if (oldSourcePartInfo.getContentHashCode() != newSourcePartInfo.getContentHashCode()) {
                this.delta.changed(newElement, 1);
            }
        }
    }

    private void findDeletions() {
        for (IEGLElement element : this.infos.keySet()) {
            this.delta.removed(element);
            this.removed(element);
        }
    }

    private EGLElementInfo getElementInfo(IEGLElement element) {
        return (EGLElementInfo)this.infos.get(element);
    }

    private ListItem getNewPosition(IEGLElement element) {
        return (ListItem)this.newPositions.get(element);
    }

    private ListItem getOldPosition(IEGLElement element) {
        return (ListItem)this.oldPositions.get(element);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.eglElement, new ListItem(null, null));
        this.putNewPosition(this.eglElement, new ListItem(null, null));
        this.delta = new EGLElementDelta(this.eglElement);
        if (this.eglElement.getElementType() >= 6) {
            this.delta.fineGrained();
        }
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(IEGLElement[] elements, boolean isNew) {
        int length = elements.length;
        IEGLElement previous = null;
        IEGLElement current = null;
        IEGLElement next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IEGLElement iEGLElement = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.putNewPosition(current, new ListItem(previous, next));
            } else {
                this.putOldPosition(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private boolean isPositionedCorrectly(IEGLElement element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IEGLElement oldPrevious = oldListItem.previous;
        IEGLElement newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private void putElementInfo(IEGLElement element, EGLElementInfo info) {
        this.infos.put(element, info);
    }

    private void putNewPosition(IEGLElement element, ListItem position) {
        this.newPositions.put(element, position);
    }

    private void putOldPosition(IEGLElement element, ListItem position) {
        this.oldPositions.put(element, position);
    }

    private void recordElementInfo(IEGLElement element, EGLModel model, int depth) {
        IEGLElement[] children;
        if (depth >= this.maxDepth) {
            return;
        }
        EGLElementInfo info = (EGLElementInfo)EGLModelManager.getEGLModelManager().getInfo(element);
        if (info == null) {
            return;
        }
        this.putElementInfo(element, info);
        if (element instanceof IParent && (children = info.getChildren()) != null) {
            this.insertPositions(children, false);
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.recordElementInfo(children[i], model, depth + 1);
                ++i;
            }
        }
    }

    private void recordNewPositions(IEGLElement newElement, int depth) {
        if (depth < this.maxDepth && newElement instanceof IParent) {
            EGLElementInfo info = null;
            try {
                info = (EGLElementInfo)((EGLElement)newElement).getElementInfo();
            }
            catch (EGLModelException eGLModelException) {
                return;
            }
            IEGLElement[] children = info.getChildren();
            if (children != null) {
                this.insertPositions(children, true);
                int i = 0;
                int length = children.length;
                while (i < length) {
                    this.recordNewPositions(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void removed(IEGLElement element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removeElementInfo(IEGLElement element) {
        this.infos.remove(element);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Built delta:\n");
        buffer.append(this.delta.toString());
        return buffer.toString();
    }

    private void trimDelta(EGLElementDelta delta) {
        if (delta.getKind() == 2) {
            IEGLElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                delta.removeAffectedChild((EGLElementDelta)children[i]);
                ++i;
            }
        } else {
            IEGLElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.trimDelta((EGLElementDelta)children[i]);
                ++i;
            }
        }
    }

    class ListItem {
        public IEGLElement previous;
        public IEGLElement next;

        public ListItem(IEGLElement previous, IEGLElement next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

