/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.core.internal.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.edt.compiler.core.ast.AbstractASTPartVisitor;
import org.eclipse.edt.compiler.core.ast.IASTVisitor;
import org.eclipse.edt.compiler.core.ast.Name;
import org.eclipse.edt.compiler.core.ast.Node;
import org.eclipse.edt.compiler.core.ast.Part;
import org.eclipse.edt.ide.core.internal.model.EGLElement;
import org.eclipse.edt.ide.core.internal.model.EGLProject;
import org.eclipse.edt.ide.core.internal.model.indexing.AbstractSearchScope;
import org.eclipse.edt.ide.core.model.EGLModelException;
import org.eclipse.edt.ide.core.model.IEGLElement;
import org.eclipse.edt.ide.core.model.IEGLElementDelta;
import org.eclipse.edt.ide.core.model.IEGLFile;
import org.eclipse.edt.ide.core.model.IEGLModel;
import org.eclipse.edt.ide.core.model.IEGLPathEntry;
import org.eclipse.edt.ide.core.model.IEGLProject;
import org.eclipse.edt.ide.core.model.IMember;
import org.eclipse.edt.ide.core.model.IOpenable;
import org.eclipse.edt.ide.core.model.IPackageFragment;
import org.eclipse.edt.ide.core.model.IPackageFragmentRoot;
import org.eclipse.edt.ide.core.search.IEGLSearchScope;

public class EGLSearchScope
extends AbstractSearchScope
implements IEGLSearchScope {
    private ArrayList elements;
    private IPath[] paths;
    private boolean[] pathWithSubFolders;
    private int pathsCount;
    private IPath[] enclosingProjects;
    private ArrayList parts;
    private Map<IPath, Set> eglarProjectsMap;

    public EGLSearchScope() {
        this.initialize();
    }

    private void addEnclosingProject(IPath path) {
        int length = this.enclosingProjects.length;
        int i = 0;
        while (i < length) {
            if (this.enclosingProjects[i].equals((Object)path)) {
                return;
            }
            ++i;
        }
        this.enclosingProjects = new IPath[length + 1];
        System.arraycopy(this.enclosingProjects, 0, this.enclosingProjects, 0, length);
        this.enclosingProjects[length] = path;
    }

    public void add(IEGLProject javaProject, boolean includesPrereqProjects, HashSet visitedProjects) throws EGLModelException {
        this.add(javaProject, includesPrereqProjects, true, visitedProjects);
    }

    public void add(IEGLProject javaProject, boolean includesPrereqProjects, boolean addNonExportedEntries, HashSet visitedProjects) throws EGLModelException {
        IProject project = javaProject.getProject();
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        this.addEnclosingProject(project.getFullPath());
        IEGLPathEntry[] entries = ((EGLProject)javaProject).getExpandedEGLPath(true);
        IEGLModel model = javaProject.getEGLModel();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            IEGLPathEntry entry = entries[i];
            switch (entry.getEntryKind()) {
                case 1: {
                    IPath path = entry.getPath();
                    this.add(path, true);
                    this.addEnclosingProject(path);
                    break;
                }
                case 2: {
                    if (!includesPrereqProjects || !addNonExportedEntries && !entry.isExported()) break;
                    this.add(model.getEGLProject(entry.getPath().lastSegment()), true, false, visitedProjects);
                    break;
                }
                case 3: {
                    this.add(entry.getPath(), true);
                }
            }
            ++i;
        }
    }

    public void add(IEGLElement element) throws EGLModelException {
        IPackageFragmentRoot root = null;
        switch (element.getElementType()) {
            case 1: {
                break;
            }
            case 2: {
                this.add((IEGLProject)element, true, new HashSet(2));
                break;
            }
            case 3: {
                root = (IPackageFragmentRoot)element;
                this.add(root.getPath(), true);
                break;
            }
            case 4: {
                root = (IPackageFragmentRoot)element.getParent();
                if (root.isArchive()) {
                    this.add(root.getPath().append((IPath)new Path(element.getElementName().replace('.', '/'))), false);
                    break;
                }
                IResource resource = element.getResource();
                if (resource == null || !resource.isAccessible()) break;
                this.add(resource.getFullPath(), false);
                break;
            }
            default: {
                if (element instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList();
                    }
                    this.elements.add(element);
                }
                this.add(this.fullPath(element), true);
                IEGLElement parent = element.getParent();
                while (parent != null && !(parent instanceof IPackageFragmentRoot)) {
                    parent = parent.getParent();
                }
                if (!(parent instanceof IPackageFragmentRoot)) break;
                root = (IPackageFragmentRoot)parent;
            }
        }
        if (root != null) {
            if (root.getKind() == 2) {
                this.addEnclosingProject(root.getPath());
            } else {
                this.addEnclosingProject(root.getEGLProject().getProject().getFullPath());
            }
        }
    }

    public void add(Node node) throws EGLModelException {
        node.accept((IASTVisitor)new AbstractASTPartVisitor(){

            private void addPart(Node part, Name name) {
                if (EGLSearchScope.this.parts == null) {
                    EGLSearchScope.this.parts = new ArrayList();
                }
                EGLSearchScope.this.parts.add(part);
                IFile file = EGLSearchScope.this.getFile(name);
                if (file != null) {
                    EGLSearchScope.this.add(file.getFullPath(), true);
                    EGLSearchScope.this.addEnclosingProject(file.getProject().getFullPath());
                }
            }

            public void visitPart(Part part) {
                this.addPart((Node)part, part.getName());
            }
        });
    }

    private void add(IPath path, boolean withSubFolders) {
        if (this.paths.length == this.pathsCount) {
            this.paths = new IPath[this.pathsCount * 2];
            System.arraycopy(this.paths, 0, this.paths, 0, this.pathsCount);
            this.pathWithSubFolders = new boolean[this.pathsCount * 2];
            System.arraycopy(this.pathWithSubFolders, 0, this.pathWithSubFolders, 0, this.pathsCount);
        }
        this.paths[this.pathsCount] = path;
        this.pathWithSubFolders[this.pathsCount++] = withSubFolders;
    }

    @Override
    public boolean encloses(String resourcePathString) {
        int index;
        if (resourcePathString.startsWith("eglar://")) {
            resourcePathString = resourcePathString.substring("eglar://".length());
        }
        if ((index = resourcePathString.indexOf("|")) != -1) {
            StringBuffer sb = new StringBuffer();
            sb.append(resourcePathString.substring(0, index));
            sb.append("/");
            sb.append(resourcePathString.substring(index + 1, resourcePathString.length()));
            resourcePathString = sb.toString();
        }
        Path resourcePath = new Path(resourcePathString);
        return this.encloses((IPath)resourcePath);
    }

    private boolean encloses(IPath path) {
        int i = 0;
        while (i < this.pathsCount) {
            IPath scopePath;
            if (this.pathWithSubFolders[i] ? this.paths[i].isPrefixOf(path) : (scopePath = this.paths[i]).isPrefixOf(path) && (scopePath.segmentCount() == path.segmentCount() - 1 || scopePath.segmentCount() == path.segmentCount())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected IFile getFile(Part part) {
        return this.getFile(part.getName());
    }

    protected IFile getFile(Name part) {
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean encloses(IEGLElement element) {
        if (this.parts != null) {
            block2: for (Node part : this.parts) {
                try {
                    IEGLElement searchedElement = element.getAncestor(8);
                    while (searchedElement != null) {
                        if (part.getOffset() == ((IMember)searchedElement).getSourceRange().getOffset()) {
                            IFile partFile = null;
                            if (part instanceof Part) {
                                partFile = this.getFile((Part)part);
                            }
                            IEGLElement elementFile = searchedElement.getAncestor(6);
                            if (partFile == null || elementFile == null || !partFile.equals((Object)((IEGLFile)elementFile).getCorrespondingResource())) continue block2;
                            return true;
                        }
                        searchedElement = searchedElement.getParent().getAncestor(8);
                    }
                }
                catch (EGLModelException eGLModelException) {}
            }
            return false;
        }
        if (this.elements != null) {
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                IEGLElement scopeElement = (IEGLElement)this.elements.get(i);
                IEGLElement searchedElement = element;
                while (searchedElement != null) {
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    searchedElement = searchedElement.getParent();
                }
                ++i;
            }
            return false;
        }
        return this.encloses(this.fullPath(element));
    }

    @Override
    public IPath[] enclosingProjects() {
        return this.enclosingProjects;
    }

    private IPath fullPath(IEGLElement element) {
        Path childPath;
        IPath parentPath;
        if (element instanceof IPackageFragmentRoot) {
            return ((IPackageFragmentRoot)element).getPath();
        }
        IEGLElement parent = element.getParent();
        IPath iPath = parentPath = parent == null ? null : this.fullPath(parent);
        if (element instanceof IPackageFragment) {
            childPath = new Path(element.getElementName().replace('.', '/'));
        } else if (element instanceof IOpenable) {
            childPath = new Path(element.getElementName());
        } else {
            return parentPath;
        }
        return parentPath == null ? childPath : parentPath.append((IPath)childPath);
    }

    protected void initialize() {
        this.paths = new IPath[1];
        this.pathWithSubFolders = new boolean[1];
        this.pathsCount = 0;
        this.enclosingProjects = new IPath[0];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void processDelta(IEGLElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                IEGLElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IEGLElementDelta child = children[i];
                    this.processDelta(child);
                    ++i;
                }
                return;
            }
            case 2: {
                IEGLElement element = delta.getElement();
                if (!this.encloses(element)) return;
                if (this.elements != null) {
                    this.elements.remove(element);
                }
                IPath path = null;
                switch (element.getElementType()) {
                    case 2: {
                        path = ((IEGLProject)element).getProject().getFullPath();
                    }
                    case 3: {
                        if (path == null) {
                            path = ((IPackageFragmentRoot)element).getPath();
                        }
                        int toRemove = -1;
                        int i = 0;
                        while (i < this.pathsCount) {
                            if (this.paths[i].equals((Object)path)) {
                                toRemove = i;
                                break;
                            }
                            ++i;
                        }
                        if (toRemove == -1) return;
                        int last = this.pathsCount - 1;
                        if (toRemove != last) {
                            this.paths[toRemove] = this.paths[last];
                            this.pathWithSubFolders[toRemove] = this.pathWithSubFolders[last];
                        }
                        --this.pathsCount;
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("EGLSearchScope on ");
        if (this.elements != null) {
            result.append("[");
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                EGLElement element = (EGLElement)this.elements.get(i);
                result.append("\n\t");
                result.append(element.toStringWithAncestors());
                ++i;
            }
            result.append("\n]");
        } else if (this.pathsCount == 0) {
            result.append("[empty scope]");
        } else {
            result.append("[");
            int i = 0;
            while (i < this.pathsCount) {
                IPath path = this.paths[i];
                result.append("\n\t");
                result.append(path.toString());
                ++i;
            }
            result.append("\n]");
        }
        return result.toString();
    }

    public void putIntoEglarProjectsMap(IPath eglarPath, IEGLProject projPath) {
        HashSet<IEGLProject> projects;
        if (this.eglarProjectsMap == null) {
            this.eglarProjectsMap = new HashMap<IPath, Set>();
        }
        if ((projects = this.eglarProjectsMap.get(eglarPath)) == null) {
            projects = new HashSet<IEGLProject>();
            this.eglarProjectsMap.put(eglarPath, projects);
        }
        projects.add(projPath);
    }

    public Map<IPath, Set> getEglarProjectsMap() {
        return this.eglarProjectsMap;
    }
}

