/*******************************************************************************
 * Copyright © 2011, 2013 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM Corporation - initial API and implementation
 *
 *******************************************************************************/
package org.eclipse.edt.ide.ui.internal.deployment.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.edt.ide.ui.internal.deployment.util.DeploymentAdapterFactory;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DeploymentItemProviderAdapterFactory extends DeploymentAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeploymentItemProviderAdapterFactory()
	{
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.Binding} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BindingItemProvider bindingItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.Binding}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBindingAdapter()
	{
		if (bindingItemProvider == null)
		{
			bindingItemProvider = new BindingItemProvider(this);
		}

		return bindingItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.Bindings} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BindingsItemProvider bindingsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.Bindings}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBindingsAdapter()
	{
		if (bindingsItemProvider == null)
		{
			bindingsItemProvider = new BindingsItemProvider(this);
		}

		return bindingsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.DeployExt} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeployExtItemProvider deployExtItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.DeployExt}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeployExtAdapter()
	{
		if (deployExtItemProvider == null)
		{
			deployExtItemProvider = new DeployExtItemProvider(this);
		}

		return deployExtItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.Deployment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeploymentItemProvider deploymentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.Deployment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeploymentAdapter()
	{
		if (deploymentItemProvider == null)
		{
			deploymentItemProvider = new DeploymentItemProvider(this);
		}

		return deploymentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.DeploymentProject} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeploymentProjectItemProvider deploymentProjectItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.DeploymentProject}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeploymentProjectAdapter()
	{
		if (deploymentProjectItemProvider == null)
		{
			deploymentProjectItemProvider = new DeploymentProjectItemProvider(this);
		}

		return deploymentProjectItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.DeploymentTarget} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeploymentTargetItemProvider deploymentTargetItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.DeploymentTarget}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDeploymentTargetAdapter()
	{
		if (deploymentTargetItemProvider == null)
		{
			deploymentTargetItemProvider = new DeploymentTargetItemProvider(this);
		}

		return deploymentTargetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EGLDeploymentRootItemProvider eglDeploymentRootItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.EGLDeploymentRoot}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEGLDeploymentRootAdapter()
	{
		if (eglDeploymentRootItemProvider == null)
		{
			eglDeploymentRootItemProvider = new EGLDeploymentRootItemProvider(this);
		}

		return eglDeploymentRootItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.Include} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IncludeItemProvider includeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.Include}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIncludeAdapter()
	{
		if (includeItemProvider == null)
		{
			includeItemProvider = new IncludeItemProvider(this);
		}

		return includeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.Parameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterItemProvider parameterItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.Parameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterAdapter()
	{
		if (parameterItemProvider == null)
		{
			parameterItemProvider = new ParameterItemProvider(this);
		}

		return parameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.Parameters} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParametersItemProvider parametersItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.Parameters}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParametersAdapter()
	{
		if (parametersItemProvider == null)
		{
			parametersItemProvider = new ParametersItemProvider(this);
		}

		return parametersItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.Resource} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceItemProvider resourceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.Resource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceAdapter()
	{
		if (resourceItemProvider == null)
		{
			resourceItemProvider = new ResourceItemProvider(this);
		}

		return resourceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.ResourceOmissions} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResourceOmissionsItemProvider resourceOmissionsItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.ResourceOmissions}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResourceOmissionsAdapter()
	{
		if (resourceOmissionsItemProvider == null)
		{
			resourceOmissionsItemProvider = new ResourceOmissionsItemProvider(this);
		}

		return resourceOmissionsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.RUIApplication} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RUIApplicationItemProvider ruiApplicationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.RUIApplication}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRUIApplicationAdapter()
	{
		if (ruiApplicationItemProvider == null)
		{
			ruiApplicationItemProvider = new RUIApplicationItemProvider(this);
		}

		return ruiApplicationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.RUIHandler} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RUIHandlerItemProvider ruiHandlerItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.RUIHandler}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRUIHandlerAdapter()
	{
		if (ruiHandlerItemProvider == null)
		{
			ruiHandlerItemProvider = new RUIHandlerItemProvider(this);
		}

		return ruiHandlerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.Service} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceItemProvider serviceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.Service}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createServiceAdapter()
	{
		if (serviceItemProvider == null)
		{
			serviceItemProvider = new ServiceItemProvider(this);
		}

		return serviceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.edt.ide.ui.internal.deployment.Services} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServicesItemProvider servicesItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.edt.ide.ui.internal.deployment.Services}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createServicesAdapter()
	{
		if (servicesItemProvider == null)
		{
			servicesItemProvider = new ServicesItemProvider(this);
		}

		return servicesItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory()
	{
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory)
	{
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type)
	{
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type)
	{
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type)
	{
		if (isFactoryForType(type))
		{
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter)))
			{
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener)
	{
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification)
	{
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null)
		{
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose()
	{
		if (bindingItemProvider != null) bindingItemProvider.dispose();
		if (bindingsItemProvider != null) bindingsItemProvider.dispose();
		if (deployExtItemProvider != null) deployExtItemProvider.dispose();
		if (deploymentItemProvider != null) deploymentItemProvider.dispose();
		if (deploymentProjectItemProvider != null) deploymentProjectItemProvider.dispose();
		if (deploymentTargetItemProvider != null) deploymentTargetItemProvider.dispose();
		if (eglDeploymentRootItemProvider != null) eglDeploymentRootItemProvider.dispose();
		if (includeItemProvider != null) includeItemProvider.dispose();
		if (parameterItemProvider != null) parameterItemProvider.dispose();
		if (parametersItemProvider != null) parametersItemProvider.dispose();
		if (resourceItemProvider != null) resourceItemProvider.dispose();
		if (resourceOmissionsItemProvider != null) resourceOmissionsItemProvider.dispose();
		if (ruiApplicationItemProvider != null) ruiApplicationItemProvider.dispose();
		if (ruiHandlerItemProvider != null) ruiHandlerItemProvider.dispose();
		if (serviceItemProvider != null) serviceItemProvider.dispose();
		if (servicesItemProvider != null) servicesItemProvider.dispose();
	}

}
