/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.edt.ide.deployment.services.operation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.edt.ide.deployment.core.model.DeploymentDesc;
import org.eclipse.edt.ide.deployment.operation.AbstractDeploymentOperation;
import org.eclipse.edt.ide.deployment.results.IDeploymentResultsCollector;
import org.eclipse.edt.ide.deployment.rui.internal.util.Utils;
import org.eclipse.edt.ide.deployment.solution.DeploymentContext;
import org.eclipse.edt.ide.ui.internal.util.CoreUtility;
import org.eclipse.edt.javart.resources.egldd.Binding;
import org.eclipse.edt.javart.resources.egldd.SQLDatabaseBinding;

public class CopyJDBCJarOperation
extends AbstractDeploymentOperation {
    private static final String WEBLIB_FOLDER = "WEB-INF/lib/";
    public static final String SEPERATOR = ";";
    private String targetProjectName;
    private DeploymentDesc ddModel;
    private DeploymentContext context;

    public void execute(DeploymentContext context, IDeploymentResultsCollector resultsCollector, IProgressMonitor monitor) throws CoreException {
        this.context = context;
        this.ddModel = context.getDeploymentDesc();
        IFolder projectRootFolder = Utils.getContextDirectory((IProject)context.getTargetProject());
        try {
            ProfileManager.getInstance().getProfiles();
            for (Binding binding : this.ddModel.getBindings()) {
                String[] jars;
                SQLDatabaseBinding sqlBinding;
                String jarList;
                if (!(binding instanceof SQLDatabaseBinding) || (jarList = (sqlBinding = (SQLDatabaseBinding)binding).getJarList()) == null) continue;
                String[] stringArray = jars = jarList.split(SEPERATOR);
                int n = jars.length;
                int n2 = 0;
                while (n2 < n) {
                    String jarPath = stringArray[n2];
                    File file = new File(jarPath);
                    if (file.exists()) {
                        FileInputStream fis = new FileInputStream(file);
                        Path path = new Path(WEBLIB_FOLDER + file.getName());
                        IPath targetFilePath = projectRootFolder.getFullPath().append((IPath)path);
                        CoreUtility.createFolder((IFolder)ResourcesPlugin.getWorkspace().getRoot().getFolder(targetFilePath.removeLastSegments(1)), (boolean)true, (boolean)true, (IProgressMonitor)monitor);
                        IFile targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile(targetFilePath);
                        if (targetFile.exists()) {
                            targetFile.setContents((InputStream)fis, true, true, monitor);
                        } else {
                            targetFile.create((InputStream)fis, true, monitor);
                        }
                        fis.close();
                    }
                    ++n2;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

