/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Graph;

public class Tarjan<T> {
    int m_index = 0;
    private final Stack<T> stack;
    Map<T, Integer> visitedNodes = Maps.newHashMap();
    Map<T, Integer> m_lowlinks = Maps.newHashMap();
    private List<T> m_cycle;

    public Tarjan(Graph<T> graph, T start) {
        this.stack = new Stack();
        this.run(graph, start);
    }

    private void run(Graph<T> graph, T start) {
        this.visitedNodes.put(start, this.m_index);
        this.m_lowlinks.put(start, this.m_index);
        ++this.m_index;
        this.stack.push(start);
        for (T predecessor : graph.getPredecessors(start)) {
            int min;
            if (!this.visitedNodes.containsKey(predecessor)) {
                this.run(graph, predecessor);
                min = Math.min(this.m_lowlinks.get(start), this.m_lowlinks.get(predecessor));
                this.m_lowlinks.put(start, min);
                continue;
            }
            if (!this.stack.contains(predecessor)) continue;
            min = Math.min(this.m_lowlinks.get(start), this.visitedNodes.get(predecessor));
            this.m_lowlinks.put(start, min);
        }
        if (Objects.equals(this.m_lowlinks.get(start), this.visitedNodes.get(start))) {
            T n;
            this.m_cycle = Lists.newArrayList();
            do {
                n = this.stack.pop();
                this.m_cycle.add(n);
            } while (!n.equals(start));
        }
    }

    public List<T> getCycle() {
        return this.m_cycle;
    }
}

