/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.constraints.builtinconstraints;

import jakarta.validation.Validator;
import jakarta.validation.constraints.AssertFalse;
import jakarta.validation.constraints.AssertTrue;
import java.util.Set;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.util.ConstraintViolationAssert;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="3.0.0")
public class AssertConstraintsTests
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)AssertConstraintsTests.webArchiveBuilder().withTestClass(AssertConstraintsTests.class)).build();
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-asserttrue", id="a")})
    public void testAssertTrueConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        AssertTrueDummyEntity dummy = new AssertTrueDummyEntity();
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(AssertTrue.class).withRootBeanClass(AssertTrueDummyEntity.class).withInvalidValue(false).withProperty("primitiveBoolean"));
        dummy.setPrimitiveBoolean(true);
        dummy.setObjectBoolean(Boolean.FALSE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(AssertTrue.class).withRootBeanClass(AssertTrueDummyEntity.class).withInvalidValue(Boolean.FALSE).withProperty("objectBoolean"));
        dummy.setObjectBoolean(Boolean.TRUE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="builtinconstraints", id="a"), @SpecAssertion(section="builtinconstraints-assertfalse", id="a")})
    public void testAssertFalseConstraint() {
        Validator validator = TestUtil.getValidatorUnderTest();
        AssertFalseDummyEntity dummy = new AssertFalseDummyEntity();
        dummy.setPrimitiveBoolean(true);
        Set constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(AssertFalse.class).withRootBeanClass(AssertFalseDummyEntity.class).withInvalidValue(true).withProperty("primitiveBoolean"));
        dummy.setPrimitiveBoolean(false);
        dummy.setObjectBoolean(Boolean.TRUE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertThat(constraintViolations).containsOnlyViolations(ConstraintViolationAssert.violationOf(AssertFalse.class).withRootBeanClass(AssertFalseDummyEntity.class).withInvalidValue(Boolean.TRUE).withProperty("objectBoolean"));
        dummy.setObjectBoolean(Boolean.FALSE);
        constraintViolations = validator.validate((Object)dummy, new Class[0]);
        ConstraintViolationAssert.assertNoViolations(constraintViolations);
    }

    private static class AssertTrueDummyEntity {
        @AssertTrue
        private boolean primitiveBoolean;
        @AssertTrue
        private Boolean objectBoolean;

        private AssertTrueDummyEntity() {
        }

        public void setPrimitiveBoolean(boolean primitiveBoolean) {
            this.primitiveBoolean = primitiveBoolean;
        }

        public void setObjectBoolean(Boolean objectBoolean) {
            this.objectBoolean = objectBoolean;
        }
    }

    private static class AssertFalseDummyEntity {
        @AssertFalse
        private boolean primitiveBoolean;
        @AssertFalse
        private Boolean objectBoolean;

        private AssertFalseDummyEntity() {
        }

        public void setPrimitiveBoolean(boolean primitiveBoolean) {
            this.primitiveBoolean = primitiveBoolean;
        }

        public void setObjectBoolean(Boolean objectBoolean) {
            this.objectBoolean = objectBoolean;
        }
    }
}

