/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.beanvalidation.tck.tests.metadata;

import java.util.Collections;
import java.util.Set;
import javax.validation.Validation;
import javax.validation.metadata.ConstructorDescriptor;
import javax.validation.metadata.MethodDescriptor;
import javax.validation.metadata.ParameterDescriptor;
import org.hibernate.beanvalidation.tck.tests.AbstractTCKTest;
import org.hibernate.beanvalidation.tck.tests.metadata.StockItem;
import org.hibernate.beanvalidation.tck.util.TestUtil;
import org.hibernate.beanvalidation.tck.util.shrinkwrap.WebArchiveBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="beanvalidation", version="2.0.0")
public class ExecutableDescriptorIgnoresValidatedExecutableXmlSettingsTest
extends AbstractTCKTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)ExecutableDescriptorIgnoresValidatedExecutableXmlSettingsTest.webArchiveBuilder().withTestClass(ExecutableDescriptorIgnoresValidatedExecutableXmlSettingsTest.class)).withClasses(StockItem.class)).withValidationXml("validation-ExecutableDescriptorIgnoresValidatedExecutableXmlSettingsTest.xml")).build();
    }

    @Test
    @SpecAssertion(section="constraintmetadata-executabledescriptor", id="h")
    public void testMethodDescriptorCanBeRetrievedAlsoIfValidateExecutableIsSetToNONEInXml() {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        MethodDescriptor descriptor = TestUtil.getMethodDescriptor(StockItem.class, "setName", String.class);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((String)descriptor.getName(), (String)"setName");
        Assert.assertEquals((int)((ParameterDescriptor)descriptor.getParameterDescriptors().get(0)).getConstraintDescriptors().size(), (int)1);
    }

    @Test
    @SpecAssertion(section="constraintmetadata-executabledescriptor", id="h")
    public void testConstructorDescriptorCanBeRetrievedAlsoIfValidateExecutableIsSetToNONEInXml() {
        Assert.assertEquals((Set)Validation.byDefaultProvider().configure().getBootstrapConfiguration().getDefaultValidatedExecutableTypes(), Collections.emptySet());
        ConstructorDescriptor descriptor = TestUtil.getConstructorDescriptor(StockItem.class, String.class);
        Assert.assertNotNull((Object)descriptor);
        Assert.assertEquals((String)descriptor.getName(), (String)"StockItem");
        Assert.assertEquals((int)((ParameterDescriptor)descriptor.getParameterDescriptors().get(0)).getConstraintDescriptors().size(), (int)1);
    }
}

