/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors.invalidation;

import java.io.Serializable;
import java.util.Random;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public abstract class CacheInvalidationPolicy
implements Serializable,
Cloneable {
    public static final long NO_EXPIRY = -1L;
    protected boolean shouldUpdateReadTimeOnUpdate = false;
    protected boolean shouldRefreshInvalidObjectsOnClone = true;
    protected boolean isInvalidationRandomized = false;
    protected Random random;

    public boolean isInvalidationRandomized() {
        return this.isInvalidationRandomized;
    }

    public void setIsInvalidationRandomized(boolean isInvalidationRandomized) {
        this.isInvalidationRandomized = isInvalidationRandomized;
        if (isInvalidationRandomized) {
            this.random = new Random();
        }
    }

    public abstract long getExpiryTimeInMillis(CacheKey var1);

    public long getRemainingValidTime(CacheKey key) {
        long expiryTime = this.getExpiryTimeInMillis(key);
        long remainingTime = expiryTime - System.currentTimeMillis();
        if (remainingTime > 0L) {
            return remainingTime;
        }
        return 0L;
    }

    public void initialize(ClassDescriptor descriptor, AbstractSession session) {
    }

    public boolean isInvalidated(CacheKey key) {
        return this.isInvalidated(key, System.currentTimeMillis());
    }

    public abstract boolean isInvalidated(CacheKey var1, long var2);

    public void setShouldUpdateReadTimeOnUpdate(boolean shouldUpdateReadTime) {
        this.shouldUpdateReadTimeOnUpdate = shouldUpdateReadTime;
    }

    public boolean shouldUpdateReadTimeOnUpdate() {
        return this.shouldUpdateReadTimeOnUpdate;
    }

    public void setShouldRefreshInvalidObjectsOnClone(boolean shouldRefreshInvalidObjectsOnClone) {
        this.shouldRefreshInvalidObjectsOnClone = shouldRefreshInvalidObjectsOnClone;
    }

    public boolean shouldRefreshInvalidObjectsOnClone() {
        return this.shouldRefreshInvalidObjectsOnClone;
    }

    public Object clone() {
        CacheInvalidationPolicy clone = null;
        try {
            clone = (CacheInvalidationPolicy)super.clone();
            clone.setShouldUpdateReadTimeOnUpdate(this.shouldUpdateReadTimeOnUpdate);
            clone.setShouldRefreshInvalidObjectsOnClone(this.shouldRefreshInvalidObjectsOnClone);
            clone.setIsInvalidationRandomized(this.isInvalidationRandomized);
        }
        catch (Exception exception) {
            throw new InternalError("clone failed");
        }
        return clone;
    }
}

