/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.deployment.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.function.Supplier;

public class WritableArchiveEntry
extends OutputStream {
    private final Supplier<OutputStream> output;
    private final CloseAction closeAction;

    public WritableArchiveEntry(Supplier<OutputStream> output, CloseAction closeAction) {
        this.output = output;
        this.closeAction = closeAction;
    }

    @Override
    public void write(int b) throws IOException {
        this.output.get().write(b);
    }

    public WritableByteChannel getChannel() {
        OutputStream out = this.output.get();
        return Channels.newChannel(out);
    }

    @Override
    public void close() throws IOException {
        this.closeAction.close();
    }

    @FunctionalInterface
    public static interface CloseAction {
        public void close() throws IOException;
    }
}

