/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.transaction.xa.XAException;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.xa.XAResourceManager;
import org.apache.derby.iapi.store.access.xa.XAXactId;
import org.apache.derby.impl.jdbc.XATransactionState;
import org.apache.derby.shared.common.error.StandardException;

public class ResourceAdapterImpl
implements ResourceAdapter,
ModuleControl {
    private boolean active;
    private XAResourceManager rm;
    private Hashtable<XAXactId, XATransactionState> connectionTable;

    @Override
    public void boot(boolean bl, Properties properties) throws StandardException {
        this.connectionTable = new Hashtable();
        AccessFactory accessFactory = (AccessFactory)ResourceAdapterImpl.findServiceModule(this, "org.apache.derby.iapi.store.access.AccessFactory");
        this.rm = (XAResourceManager)accessFactory.getXAResourceManager();
        this.active = true;
    }

    @Override
    public void stop() {
        this.active = false;
        Enumeration<XATransactionState> enumeration = this.connectionTable.elements();
        while (enumeration.hasMoreElements()) {
            XATransactionState xATransactionState = enumeration.nextElement();
            try {
                xATransactionState.conn.close();
            }
            catch (SQLException sQLException) {}
        }
        this.active = false;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public synchronized Object findConnection(XAXactId xAXactId) {
        return this.connectionTable.get(xAXactId);
    }

    @Override
    public synchronized boolean addConnection(XAXactId xAXactId, Object object) {
        if (this.connectionTable.get(xAXactId) != null) {
            return false;
        }
        this.connectionTable.put(xAXactId, (XATransactionState)object);
        return true;
    }

    @Override
    public synchronized Object removeConnection(XAXactId xAXactId) {
        return this.connectionTable.remove(xAXactId);
    }

    @Override
    public void cancelXATransaction(XAXactId xAXactId, String string) throws XAException {
        XATransactionState xATransactionState = (XATransactionState)this.findConnection(xAXactId);
        if (xATransactionState != null) {
            xATransactionState.cancel(string);
        }
    }

    @Override
    public XAResourceManager getXAResourceManager() {
        return this.rm;
    }

    private static Object findServiceModule(final Object object, final String string) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(object, string);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw StandardException.plainWrapException(privilegedActionException);
        }
    }
}

