/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import jakarta.servlet.SessionCookieConfig;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.apache.catalina.LogFacade;
import org.apache.catalina.core.StandardContext;

public class SessionCookieConfigImpl
implements SessionCookieConfig {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    private static final int DEFAULT_MAX_AGE = -1;
    private static final boolean DEFAULT_HTTP_ONLY = true;
    private static final boolean DEFAULT_SECURE = false;
    private static final String DEFAULT_NAME = "JSESSIONID";
    private String name = "JSESSIONID";
    private final Map<String, String> attributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final StandardContext ctx;

    public SessionCookieConfigImpl(StandardContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public void setName(String name) {
        this.checkContextInitialized("name");
        this.name = name;
        this.ctx.setSessionCookieName(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setDomain(String domain) {
        this.checkContextInitialized("domain");
        this.setAttribute("Domain", domain);
    }

    @Override
    public String getDomain() {
        return this.getAttribute("Domain");
    }

    @Override
    public void setPath(String path) {
        this.checkContextInitialized("path");
        this.setAttribute("Path", path);
    }

    @Override
    public String getPath() {
        return this.getAttribute("Path");
    }

    @Override
    public void setComment(String comment) {
        this.checkContextInitialized("comment");
        this.setAttribute("Comment", comment);
    }

    @Override
    public String getComment() {
        return this.getAttribute("Comment");
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        this.checkContextInitialized("httpOnly");
        this.setAttribute("HttpOnly", String.valueOf(httpOnly));
    }

    @Override
    public boolean isHttpOnly() {
        String value = this.getAttribute("HttpOnly");
        return value == null ? true : Boolean.parseBoolean(value);
    }

    @Override
    public void setSecure(boolean secure) {
        this.checkContextInitialized("secure");
        this.setAttribute("Secure", String.valueOf(secure));
    }

    @Override
    public boolean isSecure() {
        String value = this.getAttribute("Secure");
        return value == null ? false : Boolean.parseBoolean(value);
    }

    @Override
    public void setMaxAge(int maxAge) {
        this.checkContextInitialized("maxAge");
        this.setAttribute("Max-Age", String.valueOf(maxAge));
    }

    @Override
    public int getMaxAge() {
        String value = this.getAttribute("Max-Age");
        return value == null ? -1 : Integer.parseInt(value);
    }

    @Override
    public void setAttribute(String name, String value) {
        this.checkContextInitialized("attribute");
        this.checkValid(name, value);
        this.attributes.put(name, value);
    }

    @Override
    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    private void checkContextInitialized(String parameter) {
        if (this.ctx.isContextInitializedCalled()) {
            throw new IllegalStateException(MessageFormat.format(rb.getString("AS-WEB-CORE-00129"), parameter, this.ctx.getName()));
        }
    }

    private void checkValid(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
        if (name.equals("DEFAULT_MAX_AGE")) {
            Integer.parseInt(value);
        }
    }
}

