/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import com.sun.enterprise.loader.ASURLClassLoader;
import com.sun.logging.LogCleanerUtil;
import jakarta.servlet.ServletContext;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.LogFacade;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.DirContextURLStreamHandlerFactory;
import org.apache.naming.resources.Resource;
import org.glassfish.web.loader.WebappClassLoader;

public class WebappLoader
implements Lifecycle,
Loader,
PropertyChangeListener {
    private static final java.util.logging.Logger log = LogFacade.getLogger();
    private static final ResourceBundle rb = log.getResourceBundle();
    private static boolean first = true;
    private ObjectName oname;
    private ObjectName controller;
    private WebappClassLoader classLoader;
    private Container container;
    private int debug;
    private boolean delegate = true;
    private static final String info = "org.apache.catalina.loader.WebappLoader/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    private String loaderClass = WebappClassLoader.class.getName();
    private ClassLoader parentClassLoader;
    private boolean reloadable;
    private String[] repositories = new String[0];
    protected static final StringManager sm = StringManager.getManager(WebappLoader.class.getPackage().getName());
    private boolean started;
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    private String classpath;
    private Set<String> overridablePackages = Set.of();
    private boolean ignoreHiddenJarFiles;
    private boolean useMyFaces;
    private boolean initialized = false;

    public WebappLoader() {
        this(null);
    }

    public WebappLoader(ClassLoader parent) {
        this.parentClassLoader = parent;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            this.container.removePropertyChangeListener(this);
        }
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
        if (this.container instanceof Context) {
            this.setReloadable(((Context)this.container).getReloadable());
            this.container.addPropertyChangeListener(this);
        }
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        int oldDebug = this.debug;
        this.debug = debug;
        this.support.firePropertyChange("debug", (Object)oldDebug, (Object)this.debug);
    }

    @Override
    public boolean getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(boolean delegate) {
        boolean oldDelegate = this.delegate;
        this.delegate = delegate;
        this.support.firePropertyChange("delegate", (Object)oldDelegate, (Object)this.delegate);
    }

    @Override
    public String getInfo() {
        return info;
    }

    public String getLoaderClass() {
        return this.loaderClass;
    }

    public void setLoaderClass(String loaderClass) {
        this.loaderClass = loaderClass;
    }

    @Override
    public boolean getReloadable() {
        return this.reloadable;
    }

    @Override
    public void setReloadable(boolean reloadable) {
        boolean oldReloadable = this.reloadable;
        this.reloadable = reloadable;
        this.support.firePropertyChange("reloadable", (Object)oldReloadable, (Object)this.reloadable);
    }

    public void setUseMyFaces(boolean useMyFaces) {
        this.useMyFaces = useMyFaces;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    @Override
    public void addRepository(String repository) {
        if (log.isLoggable(Level.FINEST)) {
            log.log(Level.FINEST, "Adding repository " + repository);
        }
        for (String element : this.repositories) {
            if (!repository.equals(element)) continue;
            return;
        }
        String[] results = new String[this.repositories.length + 1];
        for (int i = 0; i < this.repositories.length; ++i) {
            results[i] = this.repositories[i];
        }
        results[this.repositories.length] = repository;
        this.repositories = results;
        if (this.started && this.classLoader != null) {
            this.classLoader.addRepository(repository);
            this.setClassPath();
        }
    }

    @Override
    public String[] findRepositories() {
        return (String[])this.repositories.clone();
    }

    public String[] getRepositories() {
        return (String[])this.repositories.clone();
    }

    public String getClasspath() {
        return this.classpath;
    }

    @Override
    public boolean modified() {
        return this.classLoader.modified();
    }

    public void reload() {
        if (this.classLoader != null) {
            this.classLoader.reload();
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebappLoader[");
        if (this.container != null) {
            sb.append(this.container.getName());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    @Override
    public List<LifecycleListener> findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    @Override
    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void init() {
        this.initialized = true;
        if (this.oname == null && this.container instanceof StandardContext) {
            try {
                StandardContext ctx = (StandardContext)this.container;
                String path = ctx.getEncodedPath();
                if (path.equals("")) {
                    path = "/";
                }
                this.controller = this.oname = new ObjectName(ctx.getEngineName() + ":type=Loader,path=" + path + ",host=" + ctx.getParent().getName());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00288", e);
            }
        }
    }

    public void destroy() {
        if (this.controller == this.oname) {
            this.oname = null;
        }
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initStreamHandlerFactory() {
        DirContextURLStreamHandlerFactory streamHandlerFactory = new DirContextURLStreamHandlerFactory();
        Class<WebappLoader> clazz = WebappLoader.class;
        synchronized (WebappLoader.class) {
            block7: {
                if (first) {
                    first = false;
                    try {
                        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)streamHandlerFactory);
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "AS-WEB-CORE-00289", e);
                    }
                    catch (Throwable t) {
                        if (!log.isLoggable(Level.FINE)) break block7;
                        log.log(Level.FINE, "Dual registration of jndi stream handler: " + t.getMessage());
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this.started) {
            throw new LifecycleException(rb.getString("AS-WEB-CORE-00290"));
        }
        log.log(Level.FINEST, "Starting {0}", this);
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        DirContext resources = this.container.getResources();
        if (resources == null) {
            log.log(Level.INFO, "AS-WEB-CORE-00291", this.container);
            return;
        }
        WebappLoader.initStreamHandlerFactory();
        try {
            ClassLoader cl = this.createClassLoader();
            this.classLoader = cl instanceof WebappClassLoader ? (WebappClassLoader)cl : new WebappClassLoader(cl);
            this.classLoader.setDelegate(this.delegate);
            this.classLoader.setOverridablePackages(this.overridablePackages);
            this.classLoader.setResources(resources);
            for (String element : this.repositories) {
                this.classLoader.addRepository(element);
            }
            this.setRepositories();
            this.setClassPath();
            this.startNestedClassLoader();
            DirContextURLStreamHandler.bind((ClassLoader)this.classLoader, (DirContext)resources);
        }
        catch (Throwable t) {
            log.log(Level.SEVERE, "AS-WEB-CORE-00292", t);
            throw new LifecycleException("start: ", t);
        }
    }

    @Override
    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(rb.getString("AS-WEB-CORE-00293"));
        }
        log.log(Level.FINEST, "Stopping {0}", this);
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.container instanceof Context) {
            ServletContext servletContext = ((Context)this.container).getServletContext();
            servletContext.removeAttribute("org.apache.catalina.jsp_classpath");
        }
        this.stopNestedClassLoader();
        DirContextURLStreamHandler.unbind((ClassLoader)this.classLoader);
        this.classLoader = null;
        this.destroy();
    }

    public void stopNestedClassLoader() throws LifecycleException {
        try {
            this.classLoader.close();
        }
        catch (Exception e) {
            throw new LifecycleException(e);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        String propName = event.getPropertyName();
        if ("reloadable".equals(propName)) {
            try {
                this.setReloadable((Boolean)event.getNewValue());
            }
            catch (NumberFormatException e) {
                log.log(Level.SEVERE, "AS-WEB-CORE-00294", LogCleanerUtil.neutralizeForLog((String)event.getNewValue().toString()));
            }
        }
    }

    protected ClassLoader createClassLoader() throws Exception {
        Class<?> clazz = Class.forName(this.loaderClass);
        if (this.parentClassLoader == null) {
            this.parentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        Constructor<?> constr = clazz.getConstructor(ClassLoader.class);
        WebappClassLoader webAppClassLoader = (WebappClassLoader)constr.newInstance(this.parentClassLoader);
        webAppClassLoader.setUseMyFaces(this.useMyFaces);
        return webAppClassLoader;
    }

    protected void startNestedClassLoader() throws LifecycleException {
        try {
            this.classLoader.start();
        }
        catch (Exception e) {
            throw new LifecycleException(e);
        }
    }

    private void log(String message, Throwable t) {
        Logger logger = null;
        String containerName = null;
        if (this.container != null) {
            logger = this.container.getLogger();
            containerName = this.container.getName();
        }
        if (logger != null) {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00295"), containerName, message);
            logger.log(LogCleanerUtil.neutralizeForLog((String)msg), t);
        } else {
            String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00295"), containerName, message);
            log.log(Level.WARNING, LogCleanerUtil.neutralizeForLog((String)msg), t);
        }
    }

    private void setRepositories() throws IOException {
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        File workDir = (File)servletContext.getAttribute("jakarta.servlet.context.tempdir");
        if (workDir == null && log.isLoggable(Level.INFO)) {
            log.log(Level.INFO, "AS-WEB-CORE-00296", servletContext);
        }
        if (log.isLoggable(Level.FINEST) && workDir != null) {
            log.log(Level.FINEST, "Deploying class repositories to work directory" + workDir.getAbsolutePath());
        }
        DirContext resources = this.container.getResources();
        String classesPath = "/WEB-INF/classes";
        DirContext classes = null;
        try {
            Object object = resources.lookup(classesPath);
            if (object instanceof DirContext) {
                classes = (DirContext)object;
            }
        }
        catch (NamingException object) {
            // empty catch block
        }
        if (classes != null) {
            File classRepository = null;
            String absoluteClassesPath = servletContext.getRealPath(classesPath);
            if (absoluteClassesPath != null) {
                classRepository = new File(absoluteClassesPath);
            } else {
                classRepository = new File(workDir, classesPath);
                if (!classRepository.mkdirs() && !classRepository.isDirectory()) {
                    throw new IOException(rb.getString("AS-WEB-CORE-00297"));
                }
                if (!this.copyDir(classes, classRepository)) {
                    throw new IOException(rb.getString("AS-WEB-CORE-00298"));
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Deploy class files " + classesPath + " to " + classRepository.getAbsolutePath());
            }
        }
        String libPath = this.classLoader.getLibJarPath();
        DirContext libDir = null;
        try {
            Object object = resources.lookup(libPath);
            if (object instanceof DirContext) {
                libDir = (DirContext)object;
            }
        }
        catch (NamingException object) {
            // empty catch block
        }
        if (libDir != null) {
            boolean copyJars = false;
            String absoluteLibPath = servletContext.getRealPath(libPath);
            File destDir = null;
            if (absoluteLibPath != null) {
                destDir = new File(absoluteLibPath);
            } else {
                copyJars = true;
                destDir = new File(workDir, libPath);
                if (!destDir.mkdirs() && !destDir.isDirectory()) {
                    log.log(Level.SEVERE, "AS-WEB-CORE-00299", destDir.getAbsolutePath());
                }
            }
            if (!copyJars) {
                return;
            }
            try {
                NamingEnumeration<Binding> enumeration = resources.listBindings(libPath);
                while (enumeration.hasMoreElements()) {
                    Object obj;
                    Binding binding = (Binding)enumeration.nextElement();
                    String filename = libPath + "/" + binding.getName();
                    if (!filename.endsWith(".jar") && !filename.endsWith(".zip") || binding.getName() != null && binding.getName().startsWith(".") && this.ignoreHiddenJarFiles) continue;
                    File destFile = new File(destDir, binding.getName());
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "Deploy JAR " + filename + " to " + destFile.getAbsolutePath());
                    }
                    if (!((obj = binding.getObject()) instanceof Resource)) continue;
                    Resource jarResource = (Resource)obj;
                    try (FileOutputStream fos = new FileOutputStream(destFile);){
                        if (this.copy(jarResource.streamContent(), fos)) continue;
                    }
                }
            }
            catch (NamingException enumeration) {
            }
            catch (IOException e) {
                this.log("Unable to configure repositories", e);
            }
        }
    }

    private void setClassPath() {
        String baseClasspath;
        if (!(this.container instanceof Context)) {
            return;
        }
        ServletContext servletContext = ((Context)this.container).getServletContext();
        if (servletContext == null) {
            return;
        }
        if (this.container instanceof StandardContext && (baseClasspath = ((StandardContext)this.container).getCompilerClasspath()) != null) {
            servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)baseClasspath);
            return;
        }
        StringBuilder classpath = new StringBuilder();
        boolean first = true;
        for (ClassLoader loader = this.getClassLoader(); loader != null; loader = loader.getParent()) {
            URL[] repositories;
            if (loader instanceof ASURLClassLoader) {
                String cp = ((ASURLClassLoader)ASURLClassLoader.class.cast(loader)).getClasspath();
                if (cp == null) continue;
                if (!first) {
                    classpath.append(File.pathSeparator);
                } else {
                    first = false;
                }
                classpath.append(cp);
                continue;
            }
            if (!(loader instanceof URLClassLoader)) continue;
            for (URL element : repositories = ((URLClassLoader)loader).getURLs()) {
                if (element == null) continue;
                String repository = element.toString();
                if (repository.startsWith("file://")) {
                    repository = repository.substring(7);
                } else if (repository.startsWith("file:")) {
                    repository = repository.substring(5);
                } else {
                    if (!repository.startsWith("jndi:")) continue;
                    repository = servletContext.getRealPath(repository.substring(5));
                }
                if (repository.isEmpty()) continue;
                if (!first) {
                    classpath.append(File.pathSeparator);
                } else {
                    first = false;
                }
                classpath.append(repository);
            }
        }
        this.classpath = classpath.toString();
        servletContext.setAttribute("org.apache.catalina.jsp_classpath", (Object)classpath.toString());
    }

    private boolean copyDir(DirContext srcDir, File destDir) {
        try {
            NamingEnumeration<NameClassPair> enumeration = srcDir.list("");
            while (enumeration.hasMoreElements()) {
                NameClassPair ncPair = (NameClassPair)enumeration.nextElement();
                String name = ncPair.getName();
                Object object = srcDir.lookup(name);
                File currentFile = new File(destDir, name);
                if (object instanceof Resource) {
                    FileOutputStream os;
                    InputStream is = ((Resource)object).streamContent();
                    if (this.copy(is, os = new FileOutputStream(currentFile))) continue;
                    return false;
                }
                if (object instanceof InputStream) {
                    FileOutputStream os = new FileOutputStream(currentFile);
                    if (this.copy((InputStream)object, os)) continue;
                    return false;
                }
                if (!(object instanceof DirContext)) continue;
                if (!currentFile.isDirectory() && !currentFile.mkdir()) {
                    return false;
                }
                if (this.copyDir((DirContext)object, currentFile)) continue;
                return false;
            }
        }
        catch (NamingException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean copy(InputStream is, OutputStream os) {
        try {
            int len;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) >= 0) {
                os.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public ObjectName getController() {
        return this.controller;
    }

    public void setController(ObjectName controller) {
        this.controller = controller;
    }

    @Override
    public void setOverridablePackages(Set<String> packageNames) {
        this.overridablePackages = packageNames;
    }

    @Override
    public void setIgnoreHiddenJarFiles(boolean ignoreHiddenJarFiles) {
        this.ignoreHiddenJarFiles = ignoreHiddenJarFiles;
    }
}

