/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.pde.api.tools.internal.ApiJavadocTag;
import org.eclipse.pde.api.tools.internal.CoreMessages;
import org.eclipse.pde.api.tools.internal.provisional.IApiJavadocTag;

public final class JavadocTagManager {
    public static final String TAG_NOINSTANTIATE = "@noinstantiate";
    public static final String ANNOTATION_NOINSTANTIATE = "NoInstantiate";
    public static final String TAG_NOEXTEND = "@noextend";
    public static final String ANNOTATION_NOEXTEND = "NoExtend";
    public static final String TAG_NOIMPLEMENT = "@noimplement";
    public static final String ANNOTATION_NOIMPLEMENT = "NoImplement";
    public static final String TAG_NOOVERRIDE = "@nooverride";
    public static final String ANNOTATION_NOOVERRIDE = "NoOverride";
    public static final String TAG_NOREFERENCE = "@noreference";
    public static final String ANNOTATION_NOREFERENCE = "NoReference";
    public static final Set<String> ALL_TAGS = Set.of("@noextend", "@noimplement", "@noinstantiate", "@nooverride", "@noreference");
    public static final Set<String> ALL_ANNOTATIONS = Set.of("NoExtend", "NoImplement", "NoInstantiate", "NoOverride", "NoReference");
    private static final Map<String, String> fqAnnotationNames = Map.of("NoExtend", "org.eclipse.pde.api.tools.annotations.NoExtend", "NoImplement", "org.eclipse.pde.api.tools.annotations.NoImplement", "NoInstantiate", "org.eclipse.pde.api.tools.annotations.NoInstantiate", "NoOverride", "org.eclipse.pde.api.tools.annotations.NoOverride", "NoReference", "org.eclipse.pde.api.tools.annotations.NoReference");
    private HashMap<String, IApiJavadocTag> tagcache = null;
    private HashMap<Key, Set<String>> fAnnotationCache = null;
    private IApiJavadocTag[] tags;

    private void initializeAnnotations() {
        if (this.fAnnotationCache == null) {
            this.fAnnotationCache = new HashMap();
            Set<String> annots = Set.of(ANNOTATION_NOEXTEND, ANNOTATION_NOINSTANTIATE, ANNOTATION_NOREFERENCE);
            this.fAnnotationCache.put(new Key(1, 16), annots);
            annots = Set.of(ANNOTATION_NOEXTEND, ANNOTATION_NOIMPLEMENT, ANNOTATION_NOREFERENCE);
            this.fAnnotationCache.put(new Key(2, 16), annots);
            annots = Set.of(ANNOTATION_NOOVERRIDE, ANNOTATION_NOREFERENCE);
            this.fAnnotationCache.put(new Key(1, 4), annots);
            this.fAnnotationCache.put(new Key(1, 32), annots);
            this.fAnnotationCache.put(new Key(2, 4), annots);
            annots = Set.of(ANNOTATION_NOREFERENCE);
            this.fAnnotationCache.put(new Key(1, 8), annots);
            this.fAnnotationCache.put(new Key(2, 8), annots);
            this.fAnnotationCache.put(new Key(128, 16), annots);
            this.fAnnotationCache.put(new Key(64, 16), annots);
            this.fAnnotationCache.put(new Key(64, 8), annots);
            this.fAnnotationCache.put(new Key(64, 4), annots);
        }
    }

    private void initializeJavadocTags() {
        if (this.tagcache == null) {
            this.tagcache = new LinkedHashMap<String, IApiJavadocTag>();
            ArrayList<ApiJavadocTag> list = new ArrayList<ApiJavadocTag>(4);
            ApiJavadocTag newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noimplement", "noimplement", 1);
            newtag.setApplicableTo(2, 16, CoreMessages.JavadocTagManager_interface_no_implement);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noextend", "noextend", 2);
            newtag.setApplicableTo(1, 16, CoreMessages.JavadocTagManager_class_no_subclass);
            newtag.setApplicableTo(2, 16, CoreMessages.JavadocTagManager_interface_no_extend);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.nooverride", "nooverride", 16);
            newtag.setApplicableTo(1, 4, CoreMessages.JavadocTagManager_method_no_overried);
            newtag.setApplicableTo(2, 4, CoreMessages.JavadocTagManager_default_method_no_override);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noinstantiate", "noinstantiate", 4);
            newtag.setApplicableTo(1, 16, CoreMessages.JavadocTagManager_class_no_instantiate);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            newtag = new ApiJavadocTag("org.eclipse.pde.api.tools.noreference", "noreference", 8);
            newtag.setApplicableTo(1, 16, CoreMessages.JavadocTagManager_class_no_reference);
            newtag.setApplicableTo(1, 4, CoreMessages.JavadocTagManager_method_no_reference);
            newtag.setApplicableTo(1, 32, CoreMessages.JavadocTagManager_constructor_no_reference);
            newtag.setApplicableTo(1, 8, CoreMessages.JavadocTagManager_field_no_reference);
            newtag.setApplicableTo(2, 4, CoreMessages.JavadocTagManager_method_no_reference);
            newtag.setApplicableTo(2, 8, CoreMessages.JavadocTagManager_field_no_reference);
            newtag.setApplicableTo(2, 16, CoreMessages.JavadocTagManager_interface_no_reference);
            newtag.setApplicableTo(64, 16, CoreMessages.JavadocTagManager_enum_no_reference);
            newtag.setApplicableTo(64, 8, CoreMessages.JavadocTagManager_enum_field_no_reference);
            newtag.setApplicableTo(64, 4, CoreMessages.JavadocTagManager_enum_method_no_reference);
            newtag.setApplicableTo(128, 16, CoreMessages.JavadocTagManager_annotation_no_reference);
            this.tagcache.put(newtag.getTagId(), newtag);
            list.add(newtag);
            this.tags = list.toArray(new IApiJavadocTag[list.size()]);
        }
    }

    public synchronized IApiJavadocTag[] getTagsForType(int type, int member) {
        this.initializeJavadocTags();
        ArrayList<IApiJavadocTag> list = new ArrayList<IApiJavadocTag>();
        IApiJavadocTag[] iApiJavadocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            IApiJavadocTag tag = iApiJavadocTagArray[n2];
            if (tag.isApplicable(type, member)) {
                list.add(tag);
            }
            ++n2;
        }
        return list.toArray(new IApiJavadocTag[list.size()]);
    }

    public synchronized Set<String> getAnntationsForType(int type, int member) {
        this.initializeAnnotations();
        Set<String> values = this.fAnnotationCache.get(new Key(type, member));
        if (values != null) {
            return values;
        }
        return Collections.emptySet();
    }

    public synchronized String getQualifiedNameForAnnotation(String typename) {
        return typename != null ? fqAnnotationNames.get(typename) : null;
    }

    public synchronized IApiJavadocTag getTag(String id) {
        this.initializeJavadocTags();
        return this.tagcache.get(id);
    }

    public synchronized IApiJavadocTag[] getAllTags() {
        this.initializeJavadocTags();
        if (this.tagcache == null) {
            return new IApiJavadocTag[0];
        }
        Collection<IApiJavadocTag> values = this.tagcache.values();
        return values.toArray(new IApiJavadocTag[values.size()]);
    }

    public synchronized Set<String> getAllTagNames() {
        IApiJavadocTag[] tags = this.getAllTags();
        HashSet<String> names = new HashSet<String>(tags.length);
        IApiJavadocTag[] iApiJavadocTagArray = tags;
        int n = tags.length;
        int n2 = 0;
        while (n2 < n) {
            IApiJavadocTag tag = iApiJavadocTagArray[n2];
            names.add(tag.getTagName());
            ++n2;
        }
        return names;
    }

    public synchronized int getRestrictionsForTag(String tagname, int type, int member) {
        if (tagname == null) {
            return 0;
        }
        this.initializeJavadocTags();
        IApiJavadocTag[] iApiJavadocTagArray = this.tags;
        int n = this.tags.length;
        int n2 = 0;
        while (n2 < n) {
            IApiJavadocTag tag = iApiJavadocTagArray[n2];
            if (tag.getTagName().equals(tagname) && tag.isApplicable(type, member)) {
                return tag.getRestrictionModifier();
            }
            ++n2;
        }
        return 0;
    }

    class Key {
        int type;
        int member;

        public Key(int t, int m) {
            this.type = t;
            this.member = m;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof Key) {
                void other;
                Key key = (Key)object;
                Key cfr_ignored_0 = (Key)object;
                return this.type == other.type && this.member == other.member;
            }
            return super.equals(obj);
        }

        public int hashCode() {
            return this.type + this.member;
        }
    }
}

