/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.navigator;

import org.eclipse.jdt.internal.ui.packageview.PackagesMessages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.navigator.IExtensionStateModel;

public class ShowLibrariesNodeActionGroup
extends ActionGroup {
    private IExtensionStateModel fStateModel;
    private StructuredViewer fStructuredViewer;
    private boolean fHasContributedToViewMenu = false;
    private IAction fShowLibrariesNode = null;
    private IContributionItem fShowLibrariesNodeItem = null;

    public ShowLibrariesNodeActionGroup(StructuredViewer structuredViewer, IExtensionStateModel stateModel) {
        this.fStateModel = stateModel;
        this.fStructuredViewer = structuredViewer;
    }

    public void fillActionBars(IActionBars actionBars) {
        if (!this.fHasContributedToViewMenu) {
            IMenuManager viewMenu = actionBars.getMenuManager();
            if (this.fShowLibrariesNodeItem == null) {
                this.fShowLibrariesNodeItem = new ActionContributionItem(this.fShowLibrariesNode);
            }
            viewMenu.appendToGroup("layout", this.fShowLibrariesNodeItem);
            this.fHasContributedToViewMenu = true;
        }
    }

    public void unfillActionBars(IActionBars actionBars) {
        if (this.fHasContributedToViewMenu) {
            if (this.fShowLibrariesNodeItem != null) {
                actionBars.getMenuManager().remove(this.fShowLibrariesNodeItem);
                this.fShowLibrariesNodeItem.dispose();
                this.fShowLibrariesNodeItem = null;
            }
            this.fHasContributedToViewMenu = false;
        }
    }

    public void setShowLibrariesNode(boolean showLibrariesNode) {
        if (this.fShowLibrariesNode == null) {
            this.fShowLibrariesNode = new ShowLibrariesNodeAction();
        }
        this.fShowLibrariesNode.setChecked(showLibrariesNode);
    }

    private class ShowLibrariesNodeAction
    extends Action {
        public ShowLibrariesNodeAction() {
            super(PackagesMessages.LayoutActionGroup_show_libraries_in_group, 2);
            this.setChecked(ShowLibrariesNodeActionGroup.this.fStateModel.getBooleanProperty("isLibrariesNodeShown"));
        }

        public void run() {
            boolean showLibrariesNode = this.isChecked();
            if (ShowLibrariesNodeActionGroup.this.fStateModel.getBooleanProperty("isLibrariesNodeShown") != showLibrariesNode) {
                ShowLibrariesNodeActionGroup.this.fStateModel.setBooleanProperty("isLibrariesNodeShown", showLibrariesNode);
                ShowLibrariesNodeActionGroup.this.fStructuredViewer.getControl().setRedraw(false);
                try {
                    ShowLibrariesNodeActionGroup.this.fStructuredViewer.refresh();
                }
                finally {
                    ShowLibrariesNodeActionGroup.this.fStructuredViewer.getControl().setRedraw(true);
                }
            }
        }
    }
}

