/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.CustomCodeFormatterBlock;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class CodeFormatterConfigurationBlock
extends ProfileConfigurationBlock {
    private static final String FORMATTER_DIALOG_PREFERENCE_KEY = "formatter_page";
    private static final String DIALOGSTORE_LASTSAVELOADPATH = "org.eclipse.jdt.ui.codeformatter";
    protected final String PREVIEW = "/**\n* " + FormatterMessages.CodingStyleConfigurationBlock_preview_title + "\n*/\n\n" + "package mypackage; import java.util.LinkedList; public class MyIntStack {" + "private final LinkedList fStack;" + "public MyIntStack(){fStack= new LinkedList();}" + "public int pop(){return ((Integer)fStack.removeFirst()).intValue();}" + "public void push(int elem){fStack.addFirst(new Integer(elem));}" + "public boolean isEmpty() {return fStack.isEmpty();}" + "}";
    private CompilationUnitPreview fJavaPreview;
    protected CustomCodeFormatterBlock fCustomCodeFormatterBlock;

    public CodeFormatterConfigurationBlock(IProject project, PreferencesAccess access) {
        super(project, access, DIALOGSTORE_LASTSAVELOADPATH);
        this.fCustomCodeFormatterBlock = new CustomCodeFormatterBlock(project, access);
    }

    @Override
    protected IProfileVersioner createProfileVersioner() {
        return new ProfileVersioner();
    }

    @Override
    protected ProfileStore createProfileStore(IProfileVersioner versioner) {
        return new FormatterProfileStore(versioner);
    }

    @Override
    protected ProfileManager createProfileManager(List<ProfileManager.Profile> profiles, IScopeContext context, PreferencesAccess access, IProfileVersioner profileVersioner) {
        return new FormatterProfileManager(profiles, context, access, profileVersioner);
    }

    @Override
    protected void configurePreview(Composite composite, int numColumns, ProfileManager profileManager) {
        this.fCustomCodeFormatterBlock.createContents(composite, numColumns);
        CodeFormatterConfigurationBlock.createLabel(composite, FormatterMessages.CodingStyleConfigurationBlock_preview_label_text, numColumns);
        CompilationUnitPreview result = new CompilationUnitPreview(profileManager.getSelected().getSettings(), composite);
        result.setFormatterId(this.fCustomCodeFormatterBlock.getFormatterId());
        result.setPreviewText(this.PREVIEW);
        this.fJavaPreview = result;
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fJavaPreview.getControl().setLayoutData((Object)gd);
        PreviewController previewController = new PreviewController(profileManager);
        this.fCustomCodeFormatterBlock.addObserver(previewController);
    }

    @Override
    protected ModifyDialog createModifyDialog(Shell shell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile) {
        return new FormatterModifyDialog(shell, profile, profileManager, profileStore, newProfile, FORMATTER_DIALOG_PREFERENCE_KEY, DIALOGSTORE_LASTSAVELOADPATH);
    }

    @Override
    public void performApply() {
        if (this.fCustomCodeFormatterBlock != null) {
            this.fCustomCodeFormatterBlock.performOk();
        }
        super.performApply();
    }

    @Override
    public void performDefaults() {
        if (this.fCustomCodeFormatterBlock != null) {
            this.fCustomCodeFormatterBlock.performDefaults();
        }
        super.performDefaults();
    }

    @Override
    public boolean performOk() {
        if (this.fCustomCodeFormatterBlock != null) {
            this.fCustomCodeFormatterBlock.performOk();
        }
        return super.performOk();
    }

    @Override
    public void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        if (this.fCustomCodeFormatterBlock != null) {
            this.fCustomCodeFormatterBlock.enableProjectSpecificSettings(useProjectSpecificSettings);
        }
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
    }

    private class PreviewController
    implements Observer {
        public PreviewController(ProfileManager profileManager) {
            profileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fJavaPreview.setWorkingValues(profileManager.getSelected().getSettings());
            CodeFormatterConfigurationBlock.this.fJavaPreview.update();
        }

        @Override
        public void update(Observable o, Object arg) {
            if (o instanceof ProfileManager) {
                int value = (Integer)arg;
                switch (value) {
                    case 1: 
                    case 2: 
                    case 4: 
                    case 5: {
                        CodeFormatterConfigurationBlock.this.fJavaPreview.setWorkingValues(((ProfileManager)o).getSelected().getSettings());
                        CodeFormatterConfigurationBlock.this.fJavaPreview.update();
                    }
                }
            } else if (o instanceof CustomCodeFormatterBlock) {
                String value = (String)arg;
                CodeFormatterConfigurationBlock.this.fJavaPreview.setFormatterId(value);
                CodeFormatterConfigurationBlock.this.fJavaPreview.update();
            }
        }
    }
}

