/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpace;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.ViewListener;
import fr.inria.zvtm.glyphs.DPath;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VSegment;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Picker {
    protected int jpx;
    protected int jpy;
    protected double vx;
    protected double vy;
    protected Glyph tmpGlyph;
    protected short tmpRes;
    protected int maxIndex = -1;
    Glyph[] pickedGlyphs;
    Glyph lastGlyphEntered = null;
    Rectangle pickingWindow = new Rectangle(0, 0, 1, 1);

    public Picker() {
        this(50);
    }

    public Picker(int stackSize) {
        this.pickedGlyphs = new Glyph[stackSize];
    }

    public Glyph lastGlyphEntered() {
        return this.lastGlyphEntered;
    }

    public void setJPanelCoordinates(int x, int y) {
        this.jpx = x;
        this.jpy = y;
    }

    public void setVSCoordinates(double x, double y) {
        this.vx = x;
        this.vy = y;
    }

    public Vector<DPath> getIntersectingPaths(Camera c, int tolerance, double x, double y) {
        Vector<DPath> res = new Vector<DPath>();
        Vector<Glyph> glyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
        Graphics2D g2d = c.getOwningView().getGraphicsContext();
        for (int i = 0; i < glyphs.size(); ++i) {
            Glyph glyph = glyphs.elementAt(i);
            if (!(glyph instanceof DPath) || !this.intersectsPath((DPath)glyph, tolerance, x, y, g2d)) continue;
            res.add((DPath)glyph);
        }
        return res;
    }

    public Vector<DPath> getIntersectingPaths(Camera c) {
        return this.getIntersectingPaths(c, 5, this.vx, this.vy);
    }

    public Vector<DPath> getIntersectingPaths(Camera c, int tolerance) {
        return this.getIntersectingPaths(c, tolerance, this.vx, this.vy);
    }

    public boolean intersectsPath(DPath p, int tolerance, double x, double y, Graphics2D g2d) {
        if (!p.coordsInsideBoundingBox(x, y)) {
            return false;
        }
        this.pickingWindow.setRect(x - (double)tolerance, y - (double)tolerance, 2 * tolerance, 2 * tolerance);
        return g2d.hit(this.pickingWindow, p.getJava2DGeneralPath(), true);
    }

    public boolean intersectsPath(DPath p, int tolerance, Graphics2D g2d) {
        return this.intersectsPath(p, tolerance, this.vx, this.vy, g2d);
    }

    public Vector<VSegment> getIntersectingSegments(Camera c, int tolerance) {
        return this.getIntersectingSegments(c, this.jpx, this.jpy, tolerance);
    }

    public Vector<VSegment> getIntersectingSegments(Camera c, int x, int y, int tolerance) {
        Vector<VSegment> res = new Vector<VSegment>();
        int index = c.getIndex();
        Vector<Glyph> glyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
        for (int i = 0; i < glyphs.size(); ++i) {
            Glyph glyph = glyphs.elementAt(i);
            if (!(glyph instanceof VSegment) || !this.intersectsSegment((VSegment)glyph, this.jpx, this.jpy, tolerance, index)) continue;
            res.add((VSegment)glyph);
        }
        return res;
    }

    public boolean intersectsSegment(VSegment s, int tolerance, int camIndex) {
        return this.intersectsSegment(s, this.jpx, this.jpy, camIndex, tolerance);
    }

    public boolean intersectsSegment(VSegment s, int x, int y, int tolerance, int camIndex) {
        return s.intersects(x, y, tolerance, camIndex);
    }

    public Vector<Glyph> getIntersectingGlyphs(Camera c, String type) {
        Vector<Glyph> res = new Vector<Glyph>();
        Vector<Glyph> glyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
        for (int i = 0; i < glyphs.size(); ++i) {
            Glyph glyph = glyphs.elementAt(i);
            if (type != null && !glyph.getType().equals(type)) continue;
            if (glyph.coordInside(this.jpx, this.jpy, c.getIndex(), this.vx, this.vy)) {
                res.add(glyph);
                continue;
            }
            if (glyph instanceof VSegment && this.intersectsSegment((VSegment)glyph, 2, c.getIndex())) {
                res.add(glyph);
                continue;
            }
            if (!(glyph instanceof DPath) || !this.intersectsPath((DPath)glyph, 2, c.getOwningView().getGraphicsContext())) continue;
            res.add(glyph);
        }
        return res;
    }

    public Vector<Glyph> getIntersectingGlyphs(Camera c) {
        return this.getIntersectingGlyphs(c, null);
    }

    void doubleCapacity() {
        Glyph[] tmpArray = new Glyph[this.pickedGlyphs.length * 2];
        System.arraycopy(this.pickedGlyphs, 0, tmpArray, 0, this.pickedGlyphs.length);
        this.pickedGlyphs = tmpArray;
    }

    void resetPickedGlyphsList(VirtualSpace vs, int camIndex) {
        Arrays.fill(this.pickedGlyphs, null);
        this.maxIndex = -1;
        this.lastGlyphEntered = null;
        Glyph[] gl = vs.getDrawingList();
        for (int i = 0; i < gl.length; ++i) {
            try {
                gl[i].resetMouseIn(camIndex);
                continue;
            }
            catch (NullPointerException ex) {
                if (!VirtualSpaceManager.debugModeON()) continue;
                System.err.println("Recovered from error when resetting list of glyphs under mouse");
                ex.printStackTrace();
            }
        }
    }

    public Glyph[] getPickedGlyphList() {
        if (this.maxIndex >= 0) {
            Glyph[] res = new Glyph[this.maxIndex + 1];
            System.arraycopy(this.pickedGlyphs, 0, res, 0, this.maxIndex + 1);
            return res;
        }
        return new Glyph[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Glyph[] getPickedGlyphList(String type) {
        if (this.maxIndex >= 0) {
            Vector<Glyph> gV = new Vector<Glyph>(this.maxIndex + 1);
            Glyph[] glyphArray = this.pickedGlyphs;
            synchronized (this.pickedGlyphs) {
                for (int i = 0; i <= this.maxIndex; ++i) {
                    if (this.pickedGlyphs[i].getType() == null || !this.pickedGlyphs[i].getType().equals(type)) continue;
                    gV.add(this.pickedGlyphs[i]);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return gV.toArray(new Glyph[gV.size()]);
            }
        }
        return new Glyph[0];
    }

    public boolean isPicked(Glyph g) {
        for (int i = 0; i <= this.maxIndex; ++i) {
            if (this.pickedGlyphs[i] != g) continue;
            return true;
        }
        return false;
    }

    void removeGlyphFromList(Glyph g) {
        int i = 0;
        boolean present = false;
        while (i <= this.maxIndex) {
            if (this.pickedGlyphs[i++] != g) continue;
            present = true;
            break;
        }
        while (i <= this.maxIndex) {
            this.pickedGlyphs[i - 1] = this.pickedGlyphs[i];
            ++i;
        }
        if (present) {
            --this.maxIndex;
            if (this.maxIndex < 0) {
                this.lastGlyphEntered = null;
                this.maxIndex = -1;
            } else {
                this.lastGlyphEntered = this.pickedGlyphs[this.maxIndex];
            }
        }
    }

    public boolean computePickedGlyphList(ViewListener eh, Camera c) {
        return this.computePickedGlyphList(eh, c, this.jpx, this.jpy);
    }

    boolean computePickedGlyphList(ViewListener eh, Camera c, ViewPanel v) {
        return this.computePickedGlyphList(eh, c, this.jpx, this.jpy);
    }

    boolean computePickedGlyphList(ViewListener eh, Camera c, int x, int y) {
        boolean res;
        block5: {
            res = false;
            Vector<Glyph> drawnGlyphs = c.getOwningSpace().getDrawnGlyphs(c.getIndex());
            try {
                for (int i = 0; i < drawnGlyphs.size(); ++i) {
                    this.tmpGlyph = drawnGlyphs.elementAt(i);
                    if (!this.tmpGlyph.isSensitive() || !this.checkGlyph(eh, c, x, y)) continue;
                    res = true;
                }
            }
            catch (NoSuchElementException e) {
                if (VirtualSpaceManager.debugModeON()) {
                    System.err.println("picker.computePickedGlyphList " + e);
                    e.printStackTrace();
                }
            }
            catch (NullPointerException e2) {
                if (!VirtualSpaceManager.debugModeON()) break block5;
                System.err.println("vcursor.computePickedGlyphList null " + e2 + " (This might be caused by an error in enterGlyph/exitGlyph in your event handler)");
                e2.printStackTrace();
            }
        }
        return res;
    }

    boolean checkGlyph(ViewListener eh, Camera c, int x, int y) {
        this.tmpRes = this.tmpGlyph.mouseInOut(x, y, c.getIndex(), this.vx, this.vy);
        if (this.tmpRes == 1) {
            ++this.maxIndex;
            if (this.maxIndex >= this.pickedGlyphs.length) {
                this.doubleCapacity();
            }
            this.pickedGlyphs[this.maxIndex] = this.tmpGlyph;
            this.lastGlyphEntered = this.tmpGlyph;
            eh.enterGlyph(this.tmpGlyph);
            return true;
        }
        if (this.tmpRes == -1) {
            int j = 0;
            while (j <= this.maxIndex && this.pickedGlyphs[j++] != this.tmpGlyph) {
            }
            while (j <= this.maxIndex) {
                this.pickedGlyphs[j - 1] = this.pickedGlyphs[j];
                ++j;
            }
            --this.maxIndex;
            if (this.maxIndex < 0) {
                this.lastGlyphEntered = null;
                this.maxIndex = -1;
            } else {
                this.lastGlyphEntered = this.pickedGlyphs[this.maxIndex];
            }
            eh.exitGlyph(this.tmpGlyph);
            return true;
        }
        return false;
    }

    public void printList() {
        System.err.print("[");
        for (int i = 0; i <= this.maxIndex; ++i) {
            System.err.print(this.pickedGlyphs[i].hashCode() + ",");
        }
        System.err.println("]");
    }

    public Glyph[] getDrawOrderedPickedGlyphList(VirtualSpace v) {
        Glyph[] tt = this.getPickedGlyphList();
        Glyph[] t = new Glyph[tt.length];
        int k = 0;
        Glyph[] list = v.getDrawingList();
        for (int i = 0; i < list.length; ++i) {
            if (!this.contains(tt, list[i]) || this.contains(t, list[i])) continue;
            t[k++] = list[i];
        }
        return t;
    }

    public Glyph pickOnTop(VirtualSpace v) {
        Glyph[] list = this.getDrawOrderedPickedGlyphList(v);
        if (list.length == 0) {
            return null;
        }
        return list[list.length - 1];
    }

    private boolean contains(Glyph[] tab, Glyph g) {
        for (int i = 0; i < tab.length; ++i) {
            if (tab[i] != g) continue;
            return true;
        }
        return false;
    }
}

