/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.glyphs;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.glyphs.VImage;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VImageOr<T>
extends VImage {
    int[] xcoords = new int[4];
    int[] ycoords = new int[4];

    public VImageOr(Image img, double or) {
        this(0.0, 0.0, 0, img, or, 1.0f);
    }

    public VImageOr(Image img, double or, float alpha) {
        this(0.0, 0.0, 0, img, or, alpha);
    }

    public VImageOr(double x, double y, int z, Image img, double or) {
        this(x, y, z, img, or, 1.0f);
    }

    public VImageOr(double x, double y, int z, Image img, double or, float alpha) {
        super(x, y, z, img);
        this.orient = or;
    }

    @Override
    public void orientTo(double angle) {
        this.orient = angle;
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public boolean coordInside(int jpx, int jpy, int camIndex, double cvx, double cvy) {
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    @Override
    public boolean visibleInRegion(double wb, double nb, double eb, double sb, int i) {
        if (this.vx >= wb && this.vx <= eb && this.vy >= sb && this.vy <= nb) {
            return true;
        }
        return this.vx - this.size <= eb && this.vx + this.size >= wb && this.vy - this.size <= nb && this.vy + this.size >= sb;
    }

    @Override
    public boolean visibleInDisc(double dvx, double dvy, double dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    @Override
    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = (int)Math.round((double)(d.width / 2) + (this.vx - c.vx) * this.coef);
        this.pc[i].cy = (int)Math.round((double)(d.height / 2) - (this.vy - c.vy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].cw = (int)Math.round(this.vw / 2.0 * this.coef);
            this.pc[i].ch = (int)Math.round(this.vh / 2.0 * this.coef);
        } else {
            this.pc[i].cw = (int)Math.round(this.vw / 2.0);
            this.pc[i].ch = (int)Math.round(this.vh / 2.0);
        }
        float x1 = -this.pc[i].cw;
        float y1 = -this.pc[i].ch;
        float x2 = this.pc[i].cw;
        float y2 = this.pc[i].ch;
        this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
        this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
        this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
        this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
        this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
        if (this.pc[i].p == null) {
            this.pc[i].p = new Polygon(this.xcoords, this.ycoords, 4);
        } else {
            for (int j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].p.xpoints[j] = this.xcoords[j];
                this.pc[i].p.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].p.invalidate();
        }
    }

    @Override
    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, double lensx, double lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * (double)lensMag;
        this.pc[i].lcx = (int)Math.round((double)(lensWidth / 2) + (this.vx - lensx) * this.coef);
        this.pc[i].lcy = (int)Math.round((double)(lensHeight / 2) - (this.vy - lensy) * this.coef);
        if (this.zoomSensitive) {
            this.pc[i].lcw = (int)Math.round(this.vw / 2.0 * this.coef);
            this.pc[i].lch = (int)Math.round(this.vh / 2.0 * this.coef);
        } else {
            this.pc[i].lcw = (int)Math.round(this.vw / 2.0);
            this.pc[i].lch = (int)Math.round(this.vh / 2.0);
        }
        float x1 = -this.pc[i].lcw;
        float y1 = -this.pc[i].lch;
        float x2 = this.pc[i].lcw;
        float y2 = this.pc[i].lch;
        this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
        this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
        if (this.pc[i].lp == null) {
            this.pc[i].lp = new Polygon(this.xcoords, this.ycoords, 4);
        } else {
            for (int j = 0; j < this.xcoords.length; ++j) {
                this.pc[i].lp.xpoints[j] = this.xcoords[j];
                this.pc[i].lp.ypoints[j] = this.ycoords[j];
            }
            this.pc[i].lp.invalidate();
        }
    }

    @Override
    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].cw >= 1 || this.pc[i].ch >= 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0) < (double)0.01f) {
                this.trueCoef = 1.0;
            }
            if (this.trueCoef != 1.0) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                if (this.orient != 0.0) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                        g.drawImage(this.image, this.at, null);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    } else {
                        g.drawImage(this.image, this.at, null);
                    }
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawPolygon(this.pc[i].p);
                            g.setStroke(stdS);
                        } else {
                            g.drawPolygon(this.pc[i].p);
                        }
                    }
                    g.setComposite(acO);
                } else {
                    if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                        g.drawImage(this.image, this.at, null);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    } else {
                        g.drawImage(this.image, this.at, null);
                    }
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawPolygon(this.pc[i].p);
                            g.setStroke(stdS);
                        } else {
                            g.drawPolygon(this.pc[i].p);
                        }
                    }
                }
            } else if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.orient == 0.0) {
                    g.drawImage(this.image, dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, null);
                } else {
                    this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                    g.drawImage(this.image, this.at, null);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].p);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].p);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.orient == 0.0) {
                    g.drawImage(this.image, dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, null);
                } else {
                    this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch);
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].cw, this.pc[i].ch));
                    g.drawImage(this.image, this.at, null);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].p);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].p);
                    }
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(this.pc[i].cx, this.pc[i].cy, 1, 1);
        }
    }

    @Override
    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.alphaC != null && this.alphaC.getAlpha() == 0.0f) {
            return;
        }
        if (this.pc[i].lcw >= 1 || this.pc[i].lch >= 1) {
            this.trueCoef = this.zoomSensitive ? this.scaleFactor * this.coef : this.scaleFactor;
            if (Math.abs(this.trueCoef - 1.0) < (double)0.01f) {
                this.trueCoef = 1.0;
            }
            if (this.trueCoef != 1.0) {
                this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                if (this.orient != 0.0) {
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                }
                this.at.concatenate(AffineTransform.getScaleInstance(this.trueCoef, this.trueCoef));
                if (this.alphaC != null) {
                    g.setComposite(this.alphaC);
                    if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                        g.drawImage(this.image, this.at, null);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    } else {
                        g.drawImage(this.image, this.at, null);
                    }
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawPolygon(this.pc[i].lp);
                            g.setStroke(stdS);
                        } else {
                            g.drawPolygon(this.pc[i].lp);
                        }
                    }
                    g.setComposite(acO);
                } else {
                    if (this.interpolationMethod != RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR) {
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.interpolationMethod);
                        g.drawImage(this.image, this.at, null);
                        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                    } else {
                        g.drawImage(this.image, this.at, null);
                    }
                    if (this.paintBorder) {
                        g.setColor(this.borderColor);
                        if (this.stroke != null) {
                            g.setStroke(this.stroke);
                            g.drawPolygon(this.pc[i].lp);
                            g.setStroke(stdS);
                        } else {
                            g.drawPolygon(this.pc[i].lp);
                        }
                    }
                }
            } else if (this.alphaC != null) {
                g.setComposite(this.alphaC);
                if (this.orient == 0.0) {
                    g.drawImage(this.image, dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, null);
                } else {
                    this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                    g.drawImage(this.image, this.at, null);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].lp);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].lp);
                    }
                }
                g.setComposite(acO);
            } else {
                if (this.orient == 0.0) {
                    g.drawImage(this.image, dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, null);
                } else {
                    this.at = AffineTransform.getTranslateInstance(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch);
                    this.at.concatenate(AffineTransform.getRotateInstance(-this.orient, this.pc[i].lcw, this.pc[i].lch));
                    g.drawImage(this.image, this.at, null);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].lp);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].lp);
                    }
                }
            }
        } else {
            g.setColor(this.borderColor);
            g.fillRect(dx + dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    @Override
    public Object clone() {
        VImageOr<T> res = new VImageOr<T>(this.vx, this.vy, this.vz, this.image, this.orient, this.alphaC != null ? this.alphaC.getAlpha() : 1.0f);
        res.setWidth(this.vw);
        res.setHeight(this.vh);
        res.borderColor = this.borderColor;
        res.cursorInsideColor = this.cursorInsideColor;
        res.bColor = this.bColor;
        res.setZoomSensitive(this.zoomSensitive);
        return res;
    }
}

