/*
 * Decompiled with CFR 0.152.
 */
package net.claribole.zgrviewer;

import fr.inria.zvtm.glyphs.ClosedShape;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VText;
import fr.inria.zvtm.svg.Metadata;
import java.util.Vector;
import net.claribole.zgrviewer.LEdge;
import net.claribole.zgrviewer.LElem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LNode
extends LElem {
    LEdge[] edges;
    short[] edgeDirections;

    LNode(String title, Vector<Glyph> gls) {
        int i;
        this.title = title;
        this.glyphs = new Glyph[gls.size()];
        this.URLs = new String[gls.size()];
        this.tooltips = new String[gls.size()];
        for (i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i] = gls.elementAt(i);
            if (this.glyphs[i].getOwner() == null) continue;
            this.URLs[i] = ((Metadata)this.glyphs[i].getOwner()).getURL();
            this.tooltips[i] = ((Metadata)this.glyphs[i].getOwner()).getURLTitle();
        }
        this.groupID = this.glyphs.length > 0 ? ((Metadata)this.glyphs[0].getOwner()).getClosestAncestorGroupID() : "";
        for (i = 0; i < this.glyphs.length; ++i) {
            this.glyphs[i].setOwner(this);
        }
        this.edges = new LEdge[0];
        this.edgeDirections = new short[0];
    }

    @Override
    public String getURL(Glyph g) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (g != this.glyphs[i]) continue;
            return this.URLs[i];
        }
        return null;
    }

    @Override
    public String getTooltip(Glyph g) {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (g != this.glyphs[i]) continue;
            return this.tooltips[i];
        }
        return null;
    }

    void addArc(LEdge e, short direction) {
        LEdge[] nedges = new LEdge[this.edges.length + 1];
        short[] nedgeDirections = new short[this.edgeDirections.length + 1];
        System.arraycopy(this.edges, 0, nedges, 0, this.edges.length);
        System.arraycopy(this.edgeDirections, 0, nedgeDirections, 0, this.edgeDirections.length);
        nedges[this.edges.length] = e;
        nedgeDirections[this.edgeDirections.length] = direction;
        this.edges = nedges;
        this.edgeDirections = nedgeDirections;
    }

    void removeArc(LEdge e) {
        int index = -1;
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edges[i] != e) continue;
            index = i;
            break;
        }
        if (index != -1) {
            LEdge[] nedges = new LEdge[this.edges.length - 1];
            short[] nedgeDirections = new short[this.edgeDirections.length - 1];
            System.arraycopy(this.edges, 0, nedges, 0, index);
            System.arraycopy(this.edges, index + 1, nedges, index, this.edges.length - index - 1);
            System.arraycopy(this.edgeDirections, 0, nedgeDirections, 0, index);
            System.arraycopy(this.edgeDirections, index + 1, nedgeDirections, index, this.edgeDirections.length - index - 1);
            this.edges = nedges;
            this.edgeDirections = nedgeDirections;
        }
    }

    public LEdge[] getAllArcs() {
        LEdge[] res = new LEdge[this.edges.length];
        System.arraycopy(this.edges, 0, res, 0, this.edges.length);
        return res;
    }

    public LEdge[] getOtherArcs(LEdge arc) {
        int count = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (arc == this.edges[i]) continue;
            ++count;
        }
        LEdge[] res = new LEdge[count];
        int j = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (arc == this.edges[i]) continue;
            res[j++] = this.edges[i];
        }
        return res;
    }

    public LEdge[] getOutgoingArcs() {
        int oaCount = 0;
        for (int i = 0; i < this.edgeDirections.length; ++i) {
            if (this.edgeDirections[i] != 2) continue;
            ++oaCount;
        }
        LEdge[] res = new LEdge[oaCount];
        int j = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edgeDirections[i] != 2) continue;
            res[j++] = this.edges[i];
        }
        return res;
    }

    public LEdge[] getIncomingArcs() {
        int oaCount = 0;
        for (int i = 0; i < this.edgeDirections.length; ++i) {
            if (this.edgeDirections[i] != 1) continue;
            ++oaCount;
        }
        LEdge[] res = new LEdge[oaCount];
        int j = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edgeDirections[i] != 1) continue;
            res[j++] = this.edges[i];
        }
        return res;
    }

    public LEdge[] getUndirectedArcs() {
        int oaCount = 0;
        for (int i = 0; i < this.edgeDirections.length; ++i) {
            if (this.edgeDirections[i] != 0) continue;
            ++oaCount;
        }
        LEdge[] res = new LEdge[oaCount];
        int j = 0;
        for (int i = 0; i < this.edges.length; ++i) {
            if (this.edgeDirections[i] != 0) continue;
            res[j++] = this.edges[i];
        }
        return res;
    }

    public ClosedShape getShape() {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (!(this.glyphs[i] instanceof ClosedShape)) continue;
            return (ClosedShape)this.glyphs[i];
        }
        return null;
    }

    public VText getLabel() {
        for (int i = 0; i < this.glyphs.length; ++i) {
            if (!(this.glyphs[i] instanceof VText)) continue;
            return (VText)this.glyphs[i];
        }
        return null;
    }

    public String toString() {
        String res = this.title + "[";
        for (int i = 0; i < this.edges.length; ++i) {
            res = res + (this.edges[i] != null ? this.edges[i].title + "@" + this.edges[i].hashCode() : "NULL") + "(" + this.edgeDirections[i] + ") ";
        }
        res = res + "]";
        return res;
    }
}

