/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.internal.ui.eclipse.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.emf.mwe.core.WorkflowRunner;
import org.eclipse.emf.mwe.internal.ui.workflow.Activator;
import org.eclipse.emf.mwe.ui.Messages;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

public class MWELaunchShortcut
implements ILaunchShortcut {
    private IFile currFile;
    private final ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();

    public void launch(ISelection selection, String mode) {
        IStructuredSelection structuredSelection;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            this.currFile = (IFile)((IAdaptable)object).getAdapter(IResource.class);
            this.launch(mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorInput input = editor.getEditorInput();
        this.currFile = (IFile)input.getAdapter(IFile.class);
        this.launch(mode);
    }

    private void launch(String mode) {
        try {
            this.locateWfRunner((IResource)this.currFile, mode);
        }
        catch (CoreException e) {
            Activator.logError((Exception)((Object)e));
            Activator.showError(e.getStatus());
            return;
        }
        LaunchConfigurationInfo info = new LaunchConfigurationInfo(this.currFile);
        ILaunchConfiguration config = null;
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = this.launchManager.getLaunchConfigurations();
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration configuration = iLaunchConfigurationArray[n2];
                if (info.configEquals(configuration)) {
                    config = configuration;
                    break;
                }
                ++n2;
            }
            if (config == null) {
                config = this.createConfiguration(info);
            }
            DebugUITools.launch(config, (String)mode);
            this.currFile.getProject().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Activator.logError((Exception)((Object)e));
            Activator.showError(e.getStatus());
            return;
        }
    }

    private void locateWfRunner(IResource resource, String mode) throws CoreException {
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        if (!this.isOnClasspath(WorkflowRunner.class.getName(), project)) {
            throw new DebugException(Activator.createErrorStatus(String.valueOf(Messages.MWELaunchShortcut_ExecutionError) + WorkflowRunner.class.getName() + Messages.MWELaunchShortcut_NeededonClasspath, null));
        }
    }

    private boolean checkClasspathEntries(IResource resource, String classNameToFind) throws CoreException {
        IJavaProject project = JavaCore.create((IProject)resource.getProject());
        SearchPattern pattern = SearchPattern.createPattern((String)classNameToFind, (int)0, (int)0, (int)10);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{project}, (boolean)true);
        TypeDeclarationSearchRequestor requestor = new TypeDeclarationSearchRequestor();
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, (SearchRequestor)requestor, null);
        return requestor.match();
    }

    public boolean isOnClasspath(String fullyQualifiedName, IJavaProject project) {
        if (fullyQualifiedName.indexOf(36) != -1) {
            fullyQualifiedName = fullyQualifiedName.replace('$', '.');
        }
        try {
            IType type = project.findType(fullyQualifiedName);
            return type != null && type.exists();
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    protected ILaunchConfiguration createConfiguration(LaunchConfigurationInfo info) throws CoreException {
        ILaunchConfiguration config = null;
        ILaunchConfigurationWorkingCopy wc = null;
        ILaunchConfigurationType configType = this.launchManager.getLaunchConfigurationType("org.eclipse.emf.mwe.ui.MWELaunchConfigType");
        wc = configType.newInstance(null, this.launchManager.generateUniqueLaunchConfigurationNameFrom(info.name));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, info.project);
        wc.setAttribute("startWorkflow", info.wfFile);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_STOP_IN_MAIN, false);
        wc.setAttribute("java_debug", false);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, Messages.MWELaunchShortcut_NeededVMArguments);
        config = wc.doSave();
        return config;
    }

    private class LaunchConfigurationInfo {
        private final String name;
        private final String project;
        private final String wfFile;

        private LaunchConfigurationInfo(IFile file) {
            this.name = file.getName();
            this.project = file.getProject().getName();
            this.wfFile = file.getFullPath().toString();
        }

        private boolean configEquals(ILaunchConfiguration a) throws CoreException {
            return this.wfFile.equals(a.getAttribute("startWorkflow", "X")) && this.project.equals(a.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "X"));
        }
    }

    public class TypeDeclarationSearchRequestor
    extends SearchRequestor {
        private IType match = null;

        public void acceptSearchMatch(SearchMatch match) {
            this.match = (IType)match.getElement();
        }

        public boolean match() {
            return this.match != null;
        }
    }
}

