/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

public class PropertySource
implements IPropertySource,
IPropertySource2 {
    protected Object object;
    protected IItemPropertySource itemPropertySource;

    public PropertySource(Object object, IItemPropertySource itemPropertySource) {
        this.object = object;
        this.itemPropertySource = itemPropertySource;
    }

    public Object getEditableValue() {
        return this.itemPropertySource.getEditableValue(this.object);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<IPropertyDescriptor> result = new ArrayList<IPropertyDescriptor>();
        List itemPropertyDescriptors = this.itemPropertySource.getPropertyDescriptors(this.object);
        if (itemPropertyDescriptors != null) {
            for (IItemPropertyDescriptor itemPropertyDescriptor : itemPropertyDescriptors) {
                result.add(this.createPropertyDescriptor(itemPropertyDescriptor));
            }
        }
        return result.toArray(new IPropertyDescriptor[result.size()]);
    }

    protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
        return new PropertyDescriptor(this.object, itemPropertyDescriptor);
    }

    public Object getPropertyValue(Object propertyId) {
        return this.itemPropertySource.getPropertyDescriptor(this.object, propertyId).getPropertyValue(this.object);
    }

    public boolean isPropertySet(Object propertyId) {
        return this.itemPropertySource.getPropertyDescriptor(this.object, propertyId).isPropertySet(this.object);
    }

    public boolean isPropertyResettable(Object propertyId) {
        IItemPropertyDescriptor propertyDescriptor = this.itemPropertySource.getPropertyDescriptor(this.object, propertyId);
        return propertyDescriptor.canSetProperty(this.object) && propertyDescriptor.isPropertySet(this.object);
    }

    public void resetPropertyValue(Object propertyId) {
        this.itemPropertySource.getPropertyDescriptor(this.object, propertyId).resetPropertyValue(this.object);
    }

    public void setPropertyValue(Object propertyId, Object value) {
        this.itemPropertySource.getPropertyDescriptor(this.object, propertyId).setPropertyValue(this.object, value);
    }
}

