/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class CompilationUnitAnnotationModelEvent
extends AnnotationModelEvent {
    private boolean fIncludesProblemMarkerAnnotations;
    private IResource fUnderlyingResource;

    public CompilationUnitAnnotationModelEvent(IAnnotationModel model, IResource underlyingResource) {
        super(model);
        this.fUnderlyingResource = underlyingResource;
        this.fIncludesProblemMarkerAnnotations = false;
    }

    private void testIfProblemMarker(Annotation annotation) {
        if (this.fIncludesProblemMarkerAnnotations) {
            return;
        }
        if (annotation instanceof JavaMarkerAnnotation) {
            this.fIncludesProblemMarkerAnnotations = ((JavaMarkerAnnotation)annotation).isProblem();
        } else if (annotation instanceof MarkerAnnotation) {
            try {
                IMarker marker = ((MarkerAnnotation)annotation).getMarker();
                if (!marker.exists() || marker.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                    this.fIncludesProblemMarkerAnnotations = true;
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
    }

    public void annotationAdded(Annotation annotation) {
        super.annotationAdded(annotation);
        this.testIfProblemMarker(annotation);
    }

    public void annotationRemoved(Annotation annotation) {
        super.annotationRemoved(annotation);
        this.testIfProblemMarker(annotation);
    }

    public void annotationRemoved(Annotation annotation, Position position) {
        super.annotationRemoved(annotation, position);
        this.testIfProblemMarker(annotation);
    }

    public void annotationChanged(Annotation annotation) {
        this.testIfProblemMarker(annotation);
        super.annotationChanged(annotation);
    }

    public boolean includesProblemMarkerAnnotationChanges() {
        return this.fIncludesProblemMarkerAnnotations;
    }

    public IResource getUnderlyingResource() {
        return this.fUnderlyingResource;
    }
}

