/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.templates;

import java.text.MessageFormat;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.TemplateRestriction;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameterList;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.templates.ITTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.ParsedActualParameters;
import org.eclipse.titan.designer.AST.TTCN3.templates.SpecificValue_Template;
import org.eclipse.titan.designer.AST.TTCN3.templates.TTCN3Template;
import org.eclipse.titan.designer.AST.TTCN3.types.Function_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ApplyExpression;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Invoke_Template
extends TTCN3Template {
    private static final String FUNCTIONEXPECTED = "A value of type function expected instead of `{0}''";
    private static final String TYPEMISSMATCHERROR = "Type mismatch: a value or template of type `{0}'' was expected instead of `{1}''";
    private static final String VALUEXPECTED1 = "A value of type function was expected";
    private static final String VALUEXPECTED2 = "Reference to a value was expected, but functions of type `{0}'' return a template of type `{1}''";
    private Value value;
    private ParsedActualParameters actualParameterList;

    Invoke_Template(CompilationTimeStamp timestamp, SpecificValue_Template original) {
        this.copyGeneralProperties(original);
        IValue v = original.getValue();
        if (v == null || !IValue.Value_type.EXPRESSION_VALUE.equals((Object)v.getValuetype())) {
            return;
        }
        Expression_Value expressionValue = (Expression_Value)v;
        if (!Expression_Value.Operation_type.APPLY_OPERATION.equals((Object)expressionValue.getOperationType())) {
            return;
        }
        ApplyExpression expression = (ApplyExpression)expressionValue;
        this.value = expression.getValue();
        this.actualParameterList = expression.getParameters();
    }

    @Override
    public ITTCN3Template.Template_type getTemplatetype() {
        return ITTCN3Template.Template_type.TEMPLATE_INVOKE;
    }

    @Override
    public String getTemplateTypeName() {
        if (this.isErroneous) {
            return "erroneous template returning invoke";
        }
        return "template returning invoke";
    }

    @Override
    public String createStringRepresentation() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.value.createStringRepresentation());
        builder.append(".invoke(");
        if (this.actualParameterList != null) {
            builder.append("...");
        }
        builder.append(')');
        if (this.lengthRestriction != null) {
            builder.append(this.lengthRestriction.createStringRepresentation());
        }
        if (this.isIfpresent) {
            builder.append("ifpresent");
        }
        return builder.toString();
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.value != null) {
            this.value.setMyScope(scope);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.setMyScope(scope);
        }
    }

    @Override
    public IType getExpressionGovernor(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.myGovernor != null) {
            return this.myGovernor;
        }
        if (this.value == null) {
            this.setIsErroneous(true);
            return null;
        }
        IType type = this.value.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (type == null) {
            if (!this.value.getIsErroneous(timestamp)) {
                this.value.getLocation().reportSemanticError(VALUEXPECTED1);
            }
            this.setIsErroneous(true);
            return null;
        }
        type = type.getTypeRefdLast(timestamp);
        switch (type.getTypetype()) {
            case TYPE_FUNCTION: {
                Type result = ((Function_Type)type).getReturnType();
                if (!Expected_Value_type.EXPECTED_TEMPLATE.equals((Object)expectedValue) && ((Function_Type)type).returnsTemplate()) {
                    this.location.reportSemanticError(MessageFormat.format(VALUEXPECTED2, type.getTypename(), result.getTypename()));
                }
                return result;
            }
            case TYPE_ALTSTEP: {
                this.setIsErroneous(true);
                return null;
            }
        }
        this.value.getLocation().reportSemanticError(MessageFormat.format(FUNCTIONEXPECTED, type.getTypename()));
        return null;
    }

    @Override
    public IType.Type_type getExpressionReturntype(CompilationTimeStamp timestamp, Expected_Value_type expectedValue) {
        if (this.getIsErroneous(timestamp) || this.value == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        IType type = this.value.getExpressionGovernor(timestamp, expectedValue);
        if (type == null) {
            return IType.Type_type.TYPE_UNDEFINED;
        }
        return type.getTypeRefdLast(timestamp).getTypetypeTtcn3();
    }

    @Override
    public void checkSpecificValue(CompilationTimeStamp timestamp, boolean allowOmit) {
        this.checkInvoke(timestamp);
    }

    @Override
    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
    }

    @Override
    public void checkThisTemplateGeneric(CompilationTimeStamp timestamp, IType type, boolean isModified, boolean allowOmit, boolean allowAnyOrOmit, boolean subCheck, boolean implicitOmit) {
        this.checkInvoke(timestamp);
        IType governor = this.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (governor == null) {
            this.setIsErroneous(true);
        } else if (!type.isCompatible(timestamp, governor, null, null, null)) {
            this.location.reportSemanticError(MessageFormat.format(TYPEMISSMATCHERROR, type.getTypename(), governor.getTypename()));
            this.setIsErroneous(true);
        }
        this.checkLengthRestriction(timestamp, type);
        if (!allowOmit && this.isIfpresent) {
            this.location.reportSemanticError("`ifpresent' is not allowed here");
        }
        if (subCheck) {
            type.checkThisTemplateSubtype(timestamp, this);
        }
    }

    public void checkInvoke(CompilationTimeStamp timestamp) {
        if (this.getIsErroneous(timestamp) || this.actualParameterList == null || this.value == null) {
            return;
        }
        this.value.setLoweridToReference(timestamp);
        IType type = this.value.getExpressionGovernor(timestamp, Expected_Value_type.EXPECTED_DYNAMIC_VALUE);
        if (type != null) {
            type = type.getTypeRefdLast(timestamp);
        }
        if (type == null) {
            if (!this.value.getIsErroneous(timestamp)) {
                this.value.getLocation().reportSemanticError("A value of type function was expected in the argument");
            }
            this.setIsErroneous(true);
            return;
        }
        if (!IType.Type_type.TYPE_FUNCTION.equals((Object)type.getTypetype())) {
            this.value.getLocation().reportSemanticError(MessageFormat.format("A value of type function was expected in the argument instead of `{0}''", type.getTypename()));
            this.setIsErroneous(true);
            return;
        }
        if (this.myScope == null) {
            return;
        }
        this.myScope.checkRunsOnScope(timestamp, type, (ILocateableNode)this, "call");
        FormalParameterList formalParameterList = ((Function_Type)type).getFormalParameters();
        ActualParameterList actualParameters = new ActualParameterList();
        if (!formalParameterList.checkActualParameterList(timestamp, this.actualParameterList, actualParameters)) {
            actualParameters.setFullNameParent(this);
            actualParameters.setMyScope(this.getMyScope());
        }
    }

    @Override
    public boolean checkValueomitRestriction(CompilationTimeStamp timestamp, String definitionName, boolean omitAllowed, Location usageLocation) {
        if (omitAllowed) {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_OMIT, usageLocation);
        } else {
            this.checkRestrictionCommon(timestamp, definitionName, TemplateRestriction.Restriction_type.TR_VALUE, usageLocation);
        }
        return false;
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.lengthRestriction != null) {
            this.lengthRestriction.updateSyntax(reparser, false);
            reparser.updateLocation(this.lengthRestriction.getLocation());
        }
        if (this.baseTemplate instanceof IIncrementallyUpdateable) {
            ((IIncrementallyUpdateable)((Object)this.baseTemplate)).updateSyntax(reparser, false);
            reparser.updateLocation(this.baseTemplate.getLocation());
        } else if (this.baseTemplate != null) {
            throw new ReParseException();
        }
        if (this.value != null) {
            this.value.updateSyntax(reparser, false);
            reparser.updateLocation(this.value.getLocation());
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.updateSyntax(reparser, false);
            reparser.updateLocation(this.actualParameterList.getLocation());
        }
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.value != null) {
            this.value.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.actualParameterList != null) {
            this.actualParameterList.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        if (this.value != null && !this.value.accept(v)) {
            return false;
        }
        return this.actualParameterList == null || this.actualParameterList.accept(v);
    }
}

