/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.include;

import java.util.ArrayList;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.titan.common.parsers.cfg.indices.DefineSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.pages.include.DefineItemTransfer;
import org.eclipse.titan.designer.editors.configeditor.pages.include.DefineSubPage;

public final class DefineSectionDragSourceListener
implements DragSourceListener {
    private TableViewer viewer;
    private DefineSubPage defineSubPage;

    public DefineSectionDragSourceListener(DefineSubPage defineSubPage, TableViewer viewer) {
        this.defineSubPage = defineSubPage;
        this.viewer = viewer;
    }

    public void dragFinished(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty()) {
            this.viewer.getTable().setRedraw(false);
            if (event.detail == 2) {
                this.defineSubPage.removeSelectedDefineItems();
            }
            this.viewer.getTable().setRedraw(true);
            this.viewer.refresh();
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (DefineItemTransfer.getInstance().isSupportedType(event.dataType)) {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            ArrayList<DefineSectionHandler.Definition> items = new ArrayList<DefineSectionHandler.Definition>();
            if (!selection.isEmpty()) {
                for (Object element : selection) {
                    if (!(element instanceof DefineSectionHandler.Definition)) continue;
                    items.add((DefineSectionHandler.Definition)element);
                }
                event.data = items.toArray(new DefineSectionHandler.Definition[items.size()]);
            }
        }
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        event.doit = !selection.isEmpty() && selection.getFirstElement() instanceof DefineSectionHandler.Definition;
    }
}

