/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.sew.launcher.Activator;
import org.eclipse.efm.sew.launcher.LaunchConfigurationTabGroup;
import org.eclipse.efm.sew.launcher.ui.AbstractSewLaunchConfigurationTab;
import org.eclipse.efm.sew.launcher.ui.internal.SWTFactory;
import org.eclipse.efm.sew.launcher.ui.internal.fieldeditor.BooleanFieldEditor;
import org.eclipse.efm.sew.launcher.ui.internal.fieldeditor.IntegerFieldEditor;
import org.eclipse.efm.sew.launcher.workflow.common.GraphExplorationStrategyKind;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;

public class CommonCriteriaTab
extends AbstractSewLaunchConfigurationTab {
    private IntegerFieldEditor fNodeIntegerField;
    private IntegerFieldEditor fWidthIntegerField;
    private IntegerFieldEditor fHeightIntegerField;
    private IntegerFieldEditor fStepsIntegerField;
    private IntegerFieldEditor fTimeoutIntegerField;
    private BooleanFieldEditor fInclusionCriterionBooleanField;
    private Button fBFSButton = null;
    private Button fDFSButton = null;
    private Button fRFSButton = null;
    private GraphExplorationStrategyKind fAnalyzeStrategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
    private Group groupAnalyzeStrategy;
    private Group groupInclusionCriterion;
    private TabListener fListener = new TabListener();

    public CommonCriteriaTab(LaunchConfigurationTabGroup groupTab) {
        super(groupTab);
        this.setHelpContextId("org.eclipse.efm.sew.launcher.efm_runconf_commoncriteria_tab");
    }

    IDialogSettings getDialogBoundsSettings(String id) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(id);
        if (section == null) {
            section = settings.addNewSection(id);
        }
        return section;
    }

    public void handleBFSButtonSelected() {
        if (this.fBFSButton.getSelection()) {
            this.fAnalyzeStrategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void handleDFSButtonSelected() {
        if (this.fDFSButton.getSelection()) {
            this.fAnalyzeStrategy = GraphExplorationStrategyKind.DEPTH_FIRST_SEARCH;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void handleRFSButtonSelected() {
        if (this.fRFSButton.getSelection()) {
            this.fAnalyzeStrategy = GraphExplorationStrategyKind.RANDOM_FIRST_SEARCH;
        }
        this.updateLaunchConfigurationDialog();
    }

    public void createControl(Composite parent) {
        Composite simpleComposite = SWTFactory.createComposite(parent, parent.getFont(), 1, 1, 1808, 0, 0);
        this.setControl((Control)simpleComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        this.createControlNodesHeightWidth(simpleComposite);
        this.createControlEvaluationLimits(simpleComposite);
        this.createAnalyzeStrategy(simpleComposite);
        this.createControlInclusionCriterion(simpleComposite);
    }

    public void createControlNodesHeightWidth(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Graph size limits", 5, 2, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, 1, 1, 768);
        this.fNodeIntegerField = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_NODE", "&Nodes:", comp, 100);
        this.fNodeIntegerField.setToolTipText("Maximal number of nodes (-1 <=> no-limit) of the symbolic execution tree");
        this.fWidthIntegerField = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_WIDTH", "W&idth:", comp, 100);
        this.fWidthIntegerField.setToolTipText("Maximal width (-1 <=> no-limit) of the symbolic execution tree");
        this.fHeightIntegerField = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_HEIGHT", "&Height:", comp, 100);
        this.fHeightIntegerField.setToolTipText("Maximal height (-1 <=> no-limit) of the symbolic execution tree");
    }

    public void createControlEvaluationLimits(Composite parent) {
        Group group = SWTFactory.createGroup(parent, "Evaluation limits", 5, 2, 768);
        Composite comp = SWTFactory.createComposite((Composite)group, 1, 1, 768);
        this.fStepsIntegerField = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_STEPS", "&Evaluation Steps:", comp, 1000);
        this.fStepsIntegerField.setToolTipText("Maximal steps of calculus (-1 <=> no-limit) during the symbolic execution");
        this.fTimeoutIntegerField = new IntegerFieldEditor((AbstractSewLaunchConfigurationTab)this, "org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_TIMEOUT", "&Timeout (seconds):", comp, 3600);
        this.fTimeoutIntegerField.setToolTipText("Maximal duration (-1 <=> no-limit) of the symbolic execution");
    }

    public void createControlInclusionCriterion(Composite parent) {
        this.groupInclusionCriterion = SWTFactory.createGroup(parent, "Inclusion Criterion", 5, 2, 768);
        Composite comp = SWTFactory.createComposite((Composite)this.groupInclusionCriterion, 1, 1, 768);
        this.fInclusionCriterionBooleanField = new BooleanFieldEditor(this, "org.eclipse.efm.sew.launcher.ATTR_ENABLED_INCLUSION_CRITERION", "&Apply Inclusion", comp, false);
    }

    protected void createAnalyzeStrategy(Composite parent) {
        this.groupAnalyzeStrategy = SWTFactory.createGroup(parent, "&Analyze Strategy", 3, 1, 768);
        this.fBFSButton = SWTFactory.createRadioButton((Composite)this.groupAnalyzeStrategy, "&BFS");
        this.fBFSButton.addSelectionListener((SelectionListener)this.fListener);
        this.fBFSButton.setToolTipText("Breadth First Search");
        this.fDFSButton = SWTFactory.createRadioButton((Composite)this.groupAnalyzeStrategy, "&DFS");
        this.fDFSButton.addSelectionListener((SelectionListener)this.fListener);
        this.fDFSButton.setToolTipText("Depth First Search");
        this.fRFSButton = SWTFactory.createRadioButton((Composite)this.groupAnalyzeStrategy, "&RFS");
        this.fRFSButton.addSelectionListener((SelectionListener)this.fListener);
        this.fRFSButton.setToolTipText("Random First Search");
        this.fBFSButton.setSelection(false);
        this.fDFSButton.setSelection(false);
        this.fRFSButton.setSelection(false);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        if (!this.fNodeIntegerField.isValid()) {
            this.setErrorMessage("Node is not a valid integer");
            return false;
        }
        if (!this.fWidthIntegerField.isValid()) {
            this.setErrorMessage("Width is not a valid integer");
            return false;
        }
        if (!this.fHeightIntegerField.isValid()) {
            this.setErrorMessage("Height is not a valid integer");
            return false;
        }
        if (!this.fStepsIntegerField.isValid()) {
            this.setErrorMessage("Evaluation Steps is not a valid integer");
            return false;
        }
        if (!this.fTimeoutIntegerField.isValid()) {
            this.setErrorMessage("Timeout is not a valid integer");
            return false;
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_NODE", -1);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_WIDTH", -1);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_HEIGHT", -1);
        try {
            String fModelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "");
            if (fModelAnalysis.equals("Transition Coverage")) {
                configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_STEPS", -1);
            } else {
                configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_STEPS", 1000);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_STOP_CRITERIA_TIMEOUT", -1);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_ENABLED_INCLUSION_CRITERION", false);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYZE_STRATEGY", "BFS");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        block8: {
            this.fNodeIntegerField.initializeFrom(configuration);
            this.fWidthIntegerField.initializeFrom(configuration);
            this.fHeightIntegerField.initializeFrom(configuration);
            this.fStepsIntegerField.initializeFrom(configuration);
            this.fTimeoutIntegerField.initializeFrom(configuration);
            this.fInclusionCriterionBooleanField.setEnabled(false);
            this.fInclusionCriterionBooleanField.initializeFrom(configuration);
            try {
                try {
                    this.fAnalyzeStrategy = GraphExplorationStrategyKind.get(configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYZE_STRATEGY", GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH.getLiteral()));
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    if (this.fAnalyzeStrategy == null) {
                        this.fAnalyzeStrategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
                    }
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (this.fAnalyzeStrategy == null) {
                    this.fAnalyzeStrategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
                }
                throw throwable;
            }
            if (this.fAnalyzeStrategy == null) {
                this.fAnalyzeStrategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
            }
        }
        this.initializeAnalyzeStrategy(configuration);
    }

    private void initializeAnalyzeStrategy(ILaunchConfiguration configuration) {
        try {
            String fModelAnalysis = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_MODEL_ANALYSIS", "");
            String fAnalysisProfile = configuration.getAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYSIS_PROFILE", "");
            if (fModelAnalysis.equals("Transition Coverage") || fModelAnalysis.equals("Behavior Selection") || fAnalysisProfile.equals("TESTOFFLINE")) {
                this.visibleAndExclude((Control)this.groupAnalyzeStrategy, false);
                this.visibleAndExclude((Control)this.groupInclusionCriterion, false);
                this.fBFSButton.setSelection(false);
                this.fDFSButton.setSelection(false);
                this.fRFSButton.setSelection(false);
            } else {
                this.groupAnalyzeStrategy.setVisible(true);
                this.visibleAndExclude((Control)this.groupAnalyzeStrategy, true);
                this.visibleAndExclude((Control)this.groupInclusionCriterion, true);
                switch (this.fAnalyzeStrategy) {
                    case BREADTH_FIRST_SEARCH: {
                        this.fBFSButton.setSelection(true);
                        break;
                    }
                    case DEPTH_FIRST_SEARCH: {
                        this.fDFSButton.setSelection(true);
                        break;
                    }
                    case RANDOM_FIRST_SEARCH: {
                        this.fRFSButton.setSelection(true);
                        break;
                    }
                    default: {
                        this.fBFSButton.setSelection(true);
                        this.fAnalyzeStrategy = GraphExplorationStrategyKind.BREADTH_FIRST_SEARCH;
                        break;
                    }
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.fNodeIntegerField.performApply(configuration);
        this.fWidthIntegerField.performApply(configuration);
        this.fHeightIntegerField.performApply(configuration);
        this.fStepsIntegerField.performApply(configuration);
        this.fTimeoutIntegerField.performApply(configuration);
        this.fInclusionCriterionBooleanField.performApply(configuration);
        this.fInclusionCriterionBooleanField.setEnabled(true);
        configuration.setAttribute("org.eclipse.efm.sew.launcher.ATTR_SPECIFICATION_ANALYZE_STRATEGY", this.fAnalyzeStrategy.getLiteral());
    }

    public String getName() {
        return "Common Criteria";
    }

    private class TabListener
    extends SelectionAdapter
    implements ModifyListener {
        private TabListener() {
        }

        public void modifyText(ModifyEvent e) {
            CommonCriteriaTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == CommonCriteriaTab.this.fBFSButton) {
                CommonCriteriaTab.this.handleBFSButtonSelected();
            } else if (source == CommonCriteriaTab.this.fDFSButton) {
                CommonCriteriaTab.this.handleDFSButtonSelected();
            } else if (source == CommonCriteriaTab.this.fRFSButton) {
                CommonCriteriaTab.this.handleRFSButtonSelected();
            }
        }
    }
}

