/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions.breakpointGroups;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointsListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.actions.breakpointGroups.PasteBreakpointsAction;
import org.eclipse.debug.internal.ui.viewers.model.VirtualCopyToClipboardActionDelegate;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;

public class CopyBreakpointsActionDelegate
extends VirtualCopyToClipboardActionDelegate
implements IBreakpointsListener {
    private long fStamp;

    @Override
    public void run(IAction action) {
        PasteBreakpointsAction pba;
        super.run(action);
        LocalSelectionTransfer.getTransfer().setSelection((ISelection)this.getSelection());
        this.fStamp = System.currentTimeMillis();
        LocalSelectionTransfer.getTransfer().setSelectionSetTime(this.fStamp);
        IAction pasteAction = ((AbstractDebugView)this.getView()).getAction(IDebugView.PASTE_ACTION);
        if (pasteAction instanceof PasteBreakpointsAction && (pba = (PasteBreakpointsAction)pasteAction).getStructuredSelection() != null) {
            pba.selectionChanged(pba.getStructuredSelection());
        }
    }

    @Override
    public void init(IViewPart view) {
        super.init(view);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointsListener)this);
    }

    @Override
    public void dispose() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointsListener)this);
        super.dispose();
    }

    public void breakpointsAdded(IBreakpoint[] breakpoints) {
    }

    public void breakpointsRemoved(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
        ISelection selection;
        if (this.fStamp == LocalSelectionTransfer.getTransfer().getSelectionSetTime() && (selection = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection) {
            HashSet<IBreakpoint> removed = new HashSet<IBreakpoint>();
            int i = 0;
            while (i < breakpoints.length) {
                removed.add(breakpoints[i]);
                ++i;
            }
            boolean modified = false;
            ArrayList remain = new ArrayList();
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object bp : ss) {
                if (removed.contains(bp)) {
                    modified = true;
                    continue;
                }
                remain.add(bp);
            }
            if (modified) {
                LocalSelectionTransfer.getTransfer().setSelection((ISelection)new StructuredSelection(remain));
                this.fStamp = System.currentTimeMillis();
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(this.fStamp);
            }
        }
    }

    public void breakpointsChanged(IBreakpoint[] breakpoints, IMarkerDelta[] deltas) {
    }
}

