/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.titanium.error.GUIErrorHandler;
import org.eclipse.titanium.graph.clustering.ClusteringTools;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public abstract class BaseCluster {
    protected static final String ERRORTITLE = "Clustering failure";
    protected static final String ERRORBUTTON = "Open Clustering Preferences";
    protected DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> moduleGraph;
    protected DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> clusterGraph;
    protected Set<Set<NodeDescriptor>> clusters;
    protected Map<String, Set<NodeDescriptor>> mapNameCluster;
    protected boolean successful;
    protected String msg;
    protected final GUIErrorHandler errorHandler = new GUIErrorHandler();

    public abstract boolean createClusters(IProgressMonitor var1);

    public Set<Set<NodeDescriptor>> getClusters() {
        return this.clusters;
    }

    protected void createGraph() {
        this.clusterGraph = ClusteringTools.generateClusterGraph(this.moduleGraph, this.mapNameCluster);
    }

    public DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> getGraph() {
        return this.clusterGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IProgressMonitor monitor, boolean group) {
        IProgressMonitor progress = monitor == null ? new NullProgressMonitor() : monitor;
        try {
            progress.beginTask(this.getType(), this.getTotalWork());
            progress.subTask("Creating clusters");
            this.createClusters((IProgressMonitor)new SubProgressMonitor(progress, this.getClusteringWork()));
            progress.worked(this.getClusteringWork());
            if (progress.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.successful && !group) {
                progress.subTask("Creating cluster graph");
                this.createGraph();
                progress.worked(1);
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
        }
        finally {
            progress.done();
            if (!this.successful) {
                this.reportError();
            }
        }
    }

    protected void setErronous(String msg) {
        this.successful = false;
        this.msg = msg;
    }

    protected abstract void reportError();

    protected String getType() {
        return "Clustering";
    }

    protected int getTotalWork() {
        return 3;
    }

    protected int getClusteringWork() {
        return 1;
    }

    public boolean isOK() {
        return this.successful;
    }
}

